#
# TABLE STRUCTURE FOR: ambulance_call
#

DROP TABLE IF EXISTS `ambulance_call`;

CREATE TABLE `ambulance_call` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `patient_name` varchar(50) DEFAULT NULL,
  `contact_no` varchar(30) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `vehicle_no` varchar(20) DEFAULT NULL,
  `vehicle_model` varchar(20) DEFAULT NULL,
  `driver` varchar(100) NOT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `date` datetime NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `generated_by` int(11) NOT NULL,
  `call_from` varchar(200) NOT NULL,
  `call_to` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `ambulance_call` (`id`, `bill_no`, `patient_name`, `contact_no`, `address`, `vehicle_no`, `vehicle_model`, `driver`, `amount`, `date`, `created_at`, `generated_by`, `call_from`, `call_to`) VALUES (6, '6', '31', NULL, NULL, '1', NULL, 'Depanshu', '620.00', '2020-12-18 12:03:00', '2020-12-18 06:33:21', 1, '', '');


#
# TABLE STRUCTURE FOR: appoint_priority
#

DROP TABLE IF EXISTS `appoint_priority`;

CREATE TABLE `appoint_priority` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appoint_priority` varchar(100) CHARACTER SET latin1 NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (1, 'Normal', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (2, 'Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (3, 'Very Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (4, 'Low', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `appointment_no` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `time` time DEFAULT NULL,
  `priority` varchar(100) NOT NULL,
  `patient_name` varchar(50) DEFAULT NULL,
  `gender` varchar(10) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `mobileno` varchar(50) DEFAULT NULL,
  `specialist` varchar(100) NOT NULL,
  `doctor` varchar(50) DEFAULT NULL,
  `amount` varchar(200) NOT NULL,
  `message` varchar(255) DEFAULT NULL,
  `appointment_status` varchar(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `is_opd` varchar(200) NOT NULL,
  `is_ipd` varchar(200) NOT NULL,
  `shift_id` int(11) DEFAULT NULL,
  `is_queue` int(11) NOT NULL DEFAULT '0',
  `live_consult` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8;

INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (1, 7, '', '2020-11-17 14:25:00', NULL, '1', 'Patient ', 'Male', 'Patient@gmail.com', '89898988', '', '2', '', 'The Message field is required.', 'pending', 'Offline', '2020-11-17 08:56:03', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (2, 0, '', '2020-11-27 15:51:00', NULL, '2', 'shivu', 'Female', '', '8956895868', '', '2', '', 'hjhgjghghjghjgjgjg', 'pending', 'Offline', '2020-11-24 10:22:36', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (3, 0, '', '2020-11-25 17:01:00', NULL, '1', 'subh', 'Male', '', '9565895686', '', '2', '', 'test', 'pending', 'Offline', '2020-11-24 11:31:55', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (4, 8, 'APPNO4', '2020-11-28 17:02:00', NULL, '1', 'aaaaa', '', 'demo@gmail.com', '08982022467', '', '2', '', 'na', 'approved', 'Offline', '2020-11-28 11:37:36', 'yes', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (5, 10, 'APPNO5', '2020-11-28 17:07:00', NULL, '1', 'test bg', 'Male', '', '7412589632', '', '2', '', 'appointment ', 'approved', 'Offline', '2020-11-28 11:42:21', '', '', NULL, 0, 'Yes');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (6, 0, 'APPNO6', '2020-11-28 17:09:00', NULL, '1', 'test save button', 'Male', '', '789654130', '', '2', '', 'na', 'approved', 'Offline', '2020-11-28 11:44:23', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (7, 10, '', '2020-11-28 16:57:00', NULL, '1', 'test bg', 'Female', 'srishti@gmail.com', '123456789', '', '2', '', 'testing by preeti', 'pending', 'Offline', '2020-11-28 11:54:18', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (8, 11, 'APPNO8', '2020-11-28 17:34:00', NULL, '1', 'test report', 'Male', '', '7896541230', '', '2', '', 'naa', 'approved', 'Offline', '2020-11-28 12:09:15', '', 'yes', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (9, 0, 'APPNO9', '2020-11-28 18:18:00', NULL, '1', 'garima', 'Male', 'garimarock01@gmail.com', '7896541235', '', '2', '', 'naaa', 'approved', 'Offline', '2020-11-28 12:54:09', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (10, 11, 'APPNO10', '2020-11-28 18:21:00', NULL, '1', 'test report', 'Male', '', '7896541230', '', '2', '', 'nnn', 'approved', 'Offline', '2020-11-28 12:56:24', '', '', NULL, 0, 'Yes');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (11, 0, 'APPNO11', '2020-11-28 18:29:00', NULL, '1', 'live consultation ', 'Male', 'na', '7879654212', '', '2', '', 'naa', 'approved', 'Offline', '2020-11-28 13:04:30', '', '', NULL, 0, 'Yes');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (12, 16, 'APPNO12', '2020-11-28 18:30:00', NULL, '1', 'test ', 'Male', 'fff', '7896541230', '', '2', '', 'naa', 'approved', 'Offline', '2020-11-28 13:05:42', '', '', NULL, 0, 'Yes');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (13, 0, '', '2020-12-01 18:31:00', NULL, '1', 'ffff', 'Male', '', '741258963', '', '2', '', 'na', 'cancel', 'Offline', '2020-11-28 13:06:01', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (14, 16, 'APPNO14', '2020-11-30 17:01:00', NULL, '1', 'test', 'Male', 'fff', '789654', '', '2', '', 'na', 'approved', 'Offline', '2020-11-30 11:36:10', 'yes', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (15, 18, 'APPNO15', '2020-11-30 17:02:00', NULL, '1', 'save test', 'Male', '', '789654123', '', '2', '', 'naa', 'approved', 'Offline', '2020-11-30 11:37:51', '', '', NULL, 0, 'Yes');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (16, 0, 'APPNO16', '2020-11-30 17:03:00', NULL, '1', 'ttttttttttttttttttt', 'Female', '', '896566', '', '2', '', 'naaa', 'approved', 'Offline', '2020-11-30 11:38:14', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (17, 22, 'APPNO17', '2020-11-30 17:03:00', NULL, '1', 'saveeeee', 'Male', '', '789654123', '', '2', '', 'naaa', 'approved', 'Offline', '2020-11-30 11:38:37', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (18, 0, 'APPNO18', '2020-11-30 17:04:00', NULL, '1', 'gg', 'Male', '', '122', '', '2', '', 'g', 'approved', 'Offline', '2020-11-30 11:39:08', '', '', NULL, 0, 'Yes');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (19, 16, '', '2020-11-30 17:09:00', NULL, '1', 'test', 'Male', 'fff', '789654', '', '2', '', 'naa', 'pending', 'Offline', '2020-11-30 11:43:50', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (20, 0, 'APPNO20', '2020-11-30 17:10:00', NULL, '1', 'test', 'Female', '', '45665', '', '2', '', 'na', 'approved', 'Offline', '2020-11-30 11:45:30', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (21, 17, 'APPNO21', '2020-12-01 17:36:00', NULL, '1', 'ginni test', '', '', '8744669960', '', '2', '', 'na', 'approved', 'Offline', '2020-11-30 12:12:58', 'yes', '', NULL, 0, 'Yes');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (22, 19, 'APPNO22', '2020-11-30 17:44:00', NULL, '1', 'garima marko', 'Female', 'garimarock01@gmail.com', '8451236975665', '', '2', '', 'naa', 'approved', 'Offline', '2020-11-30 12:19:42', '', '', NULL, 0, 'Yes');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (23, 20, 'APPNO23', '2020-12-02 11:34:00', NULL, '1', 'Rashmi', 'Female', '', '8745123690', '', '2', '', 'Naa', 'approved', 'Offline', '2020-12-02 06:10:44', '', '', NULL, 0, 'Yes');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (24, 28, 'APPNO24', '2020-12-05 16:52:00', NULL, '1', 'rahul', 'Male', 'rahul@gmail.com.', '789654130', '', '2', '', 'NAA', 'approved', 'Offline', '2020-12-05 11:28:01', '', '', NULL, 0, 'Yes');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (25, 16, '', '2020-12-19 12:35:00', NULL, '1', 'test', 'Male', 'fff', '789654', '', '2', '', 'ttttttttt', 'pending', 'Offline', '2020-12-19 07:06:16', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (26, 0, 'APPNO26', '2020-12-16 12:48:00', NULL, '1', 'subh', 'Male', '', '8686868688', '', '2', '', 'test gfggsg', 'approved', 'Offline', '2020-12-19 07:18:57', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (27, 0, 'APPNO27', '2020-12-28 11:34:00', NULL, '2', 'Ravi', 'Male', 'Ravi@gmail.com', '8211110210', '', '2', '', 'text', 'approved', 'Offline', '2020-12-28 06:08:07', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (29, 9, 'APPNO29', '2021-01-11 00:00:00', '11:20:00', '', NULL, NULL, NULL, NULL, '2', '2', '', NULL, 'approved', '', '2021-01-06 12:51:57', '', '', 21, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (36, 51, 'APPNO36', '2021-01-11 00:00:00', NULL, '', NULL, NULL, NULL, NULL, '2', '2', '', NULL, 'approved', 'Offline', '2021-01-07 10:59:12', '', '', 21, 1, '');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (37, 0, '', '2021-01-06 16:50:00', NULL, '1', 'test', 'Male', '', '567574', '', '2', '', 'vbvcxvcxvxcv', 'pending', 'Offline', '2021-01-07 11:20:37', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (38, 0, '', '2021-01-07 16:51:00', NULL, '1', 'ttttttt', '', '', '53434', '', '2', '', 'fggfgf', 'pending', 'Offline', '2021-01-07 11:21:46', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (41, 0, '', '2021-01-08 17:16:00', NULL, '1', 'aaaaaa', '', '', '898989', '', '2', '', 'fgffdsf', 'pending', 'Offline', '2021-01-08 11:47:14', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (42, 0, '', '2021-01-08 17:17:00', NULL, '1', 'aaaaaaaa', 'Male', '', '89898', '', '2', '', 'sdfsdfsdfds', 'pending', 'Offline', '2021-01-08 11:47:33', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (44, 0, '', '2021-01-08 17:45:00', NULL, '1', 'ssssss', 'Male', '', '65465464', '', '2', '', 'sssss', 'pending', 'Offline', '2021-01-08 12:16:01', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (45, 0, '', '2021-01-13 18:00:00', NULL, '1', 'denish', 'Male', '', '8739473433', '', '7', '', 'tersttstrrtstdfg gfdgfdsg  fdfdf fdfd', 'pending', 'Offline', '2021-01-08 12:31:08', '', '', NULL, 0, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (46, 31, 'APPNO46', '2021-01-11 12:24:00', NULL, '2', 'Rahul Agrawal', 'Male', 'rahulagrawal0708@gmail.com', '1234568970', '', '2', '', 'test', 'approved', 'Offline', '2021-01-09 06:55:32', '', '', NULL, 1, 'Yes');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (47, 35, 'APPNO47', '2021-01-11 12:40:00', NULL, '1', 'aaaaaa', 'Male', '', '54353543', '', '2', '', 'test', 'approved', 'Offline', '2021-01-09 07:10:49', '', '', NULL, 1, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (48, 26, 'APPNO48', '2021-01-11 12:40:00', NULL, '1', 'rahul', '', 'rahul@gmail.com.', '789654130', '', '2', '', 'test', 'approved', 'Offline', '2021-01-09 07:11:16', '', '', NULL, 1, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (55, 9, 'APPNO55', '2021-01-11 00:00:00', '11:00:00', '', NULL, NULL, NULL, NULL, '2', '2', '', NULL, 'approved', 'Online', '2021-01-13 06:43:59', '', '', 1, 1, '');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (56, 9, 'APPNO56', '2021-01-11 00:00:00', '11:30:00', '', NULL, NULL, NULL, NULL, '2', '2', '', NULL, 'approved', 'Online', '2021-01-13 07:31:50', '', '', 1, 1, '');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (57, 9, 'APPNO57', '2021-01-11 00:00:00', '12:30:00', '', NULL, NULL, NULL, NULL, '2', '2', '', NULL, 'approved', 'Online', '2021-01-13 08:48:44', '', '', 1, 1, '');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (58, 53, 'APPNO58', '2021-01-11 00:00:00', '12:00:00', '', NULL, NULL, NULL, NULL, '2', '2', '', NULL, 'approved', 'Online', '2021-01-13 08:57:58', '', '', 1, 1, '');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (59, 9, 'APPNO59', '2021-01-18 00:00:00', '11:00:00', '', NULL, NULL, NULL, NULL, '2', '2', '', NULL, 'approved', 'Online', '2021-01-13 10:25:49', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (60, 53, 'APPNO60', '2021-01-11 12:21:00', NULL, '1', 'sagar', 'Female', 'sagar.shrivastav889@gmail.com', '09926226695', '', '2', '', 'test', 'approved', 'Offline', '2021-01-14 06:51:56', '', '', NULL, 1, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (62, 9, '', '2021-01-18 00:00:00', '11:30:00', '', NULL, NULL, NULL, NULL, '2', '2', '', NULL, 'pending', 'Online', '2021-01-15 10:05:05', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (63, 31, 'APPNO63', '2021-01-11 16:04:00', NULL, '1', 'Rahul Agrawal', 'Male', 'rahulagrawal0708@gmail.com', '1234568970', '', '2', '', 'test', 'approved', 'Offline', '2021-01-16 10:34:31', '', '', NULL, 1, 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (64, 55, 'APPNO64', '2021-01-18 00:00:00', '12:00:00', '', NULL, NULL, NULL, NULL, '2', '2', '', NULL, 'approved', 'Online', '2021-01-18 10:53:20', '', '', 1, 0, '');


#
# TABLE STRUCTURE FOR: appointment_queue
#

DROP TABLE IF EXISTS `appointment_queue`;

CREATE TABLE `appointment_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) NOT NULL,
  `position` int(11) NOT NULL,
  `doctor_id` int(11) NOT NULL,
  `global_shift_id` int(11) NOT NULL,
  `date` date NOT NULL DEFAULT '2021-01-11',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=utf8;

INSERT INTO `appointment_queue` (`id`, `appointment_id`, `position`, `doctor_id`, `global_shift_id`, `date`, `created_at`) VALUES (122, 36, 6, 2, 1, '2021-01-11', '2021-01-16 12:13:24');
INSERT INTO `appointment_queue` (`id`, `appointment_id`, `position`, `doctor_id`, `global_shift_id`, `date`, `created_at`) VALUES (123, 60, 1, 2, 1, '2021-01-11', '2021-01-18 10:11:17');
INSERT INTO `appointment_queue` (`id`, `appointment_id`, `position`, `doctor_id`, `global_shift_id`, `date`, `created_at`) VALUES (124, 55, 2, 2, 1, '2021-01-11', '2021-01-18 10:11:17');
INSERT INTO `appointment_queue` (`id`, `appointment_id`, `position`, `doctor_id`, `global_shift_id`, `date`, `created_at`) VALUES (125, 56, 7, 2, 1, '2021-01-11', '2021-01-16 12:13:24');
INSERT INTO `appointment_queue` (`id`, `appointment_id`, `position`, `doctor_id`, `global_shift_id`, `date`, `created_at`) VALUES (126, 58, 5, 2, 1, '2021-01-11', '2021-01-16 12:13:24');
INSERT INTO `appointment_queue` (`id`, `appointment_id`, `position`, `doctor_id`, `global_shift_id`, `date`, `created_at`) VALUES (127, 57, 4, 2, 1, '2021-01-11', '2021-01-16 12:13:23');
INSERT INTO `appointment_queue` (`id`, `appointment_id`, `position`, `doctor_id`, `global_shift_id`, `date`, `created_at`) VALUES (128, 46, 8, 2, 1, '2021-01-11', '2021-01-16 12:13:24');
INSERT INTO `appointment_queue` (`id`, `appointment_id`, `position`, `doctor_id`, `global_shift_id`, `date`, `created_at`) VALUES (129, 47, 3, 2, 1, '2021-01-11', '2021-01-16 12:13:23');
INSERT INTO `appointment_queue` (`id`, `appointment_id`, `position`, `doctor_id`, `global_shift_id`, `date`, `created_at`) VALUES (130, 48, 9, 2, 1, '2021-01-11', '2021-01-16 12:10:40');
INSERT INTO `appointment_queue` (`id`, `appointment_id`, `position`, `doctor_id`, `global_shift_id`, `date`, `created_at`) VALUES (131, 63, 10, 2, 1, '2021-01-11', '2021-01-16 12:10:40');


#
# TABLE STRUCTURE FOR: bed
#

DROP TABLE IF EXISTS `bed`;

CREATE TABLE `bed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `bed_type_id` int(11) NOT NULL,
  `bed_group_id` int(100) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (1, 'A1', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (2, 'A2', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (3, 'A3', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (4, 'A4', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (5, 'vcbvnb', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (6, 'A5', 1, 5, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (7, 'A6', 3, 4, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (8, 'A7', 1, 2, 'yes');


#
# TABLE STRUCTURE FOR: bed_group
#

DROP TABLE IF EXISTS `bed_group`;

CREATE TABLE `bed_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `floor` varchar(100) NOT NULL,
  `is_active` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (1, 'G1', '', '1', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (2, 'F1', '', '2', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (3, 'S1', '', '3', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (4, 'G1', '', '2', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (5, 'F2', '', '3', 0);


#
# TABLE STRUCTURE FOR: bed_type
#

DROP TABLE IF EXISTS `bed_type`;

CREATE TABLE `bed_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `bed_type` (`id`, `name`) VALUES (1, 'Single');
INSERT INTO `bed_type` (`id`, `name`) VALUES (2, 'Normal');
INSERT INTO `bed_type` (`id`, `name`) VALUES (3, 'Double ');


#
# TABLE STRUCTURE FOR: birth_report
#

DROP TABLE IF EXISTS `birth_report`;

CREATE TABLE `birth_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_no` varchar(200) NOT NULL,
  `opd_ipd_no` varchar(200) NOT NULL,
  `child_name` varchar(200) NOT NULL,
  `child_pic` varchar(200) NOT NULL,
  `gender` varchar(200) NOT NULL,
  `birth_date` datetime NOT NULL,
  `weight` varchar(200) NOT NULL,
  `mother_name` varchar(200) NOT NULL,
  `contact` varchar(200) NOT NULL,
  `mother_pic` varchar(200) NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `father_pic` varchar(200) NOT NULL,
  `birth_report` mediumtext NOT NULL,
  `document` varchar(200) NOT NULL,
  `address` varchar(200) NOT NULL,
  `is_active` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `birth_report` (`id`, `ref_no`, `opd_ipd_no`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `mother_name`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (1, '', '', 'subh', '', 'Male', '2020-11-19 17:59:00', '4', '2', '9586598659', '', '', '', '', '', 'Bhopal', 'yes', '2020-11-18 12:30:08');
INSERT INTO `birth_report` (`id`, `ref_no`, `opd_ipd_no`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `mother_name`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (2, 'BR20202', '', 'hghgg', 'uploads/patient_images/no_image.png', 'Male', '2020-12-03 13:14:00', '520', '19', '12365485', 'uploads/patient_images/no_image.png', 'bbbb', 'uploads/patient_images/no_image.png', 'bbbb', '', 'fdgdfg', 'yes', '2020-12-02 07:49:39');
INSERT INTO `birth_report` (`id`, `ref_no`, `opd_ipd_no`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `mother_name`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (3, 'BR19703', '', 'dfgdfgdfdfdfdfg', 'uploads/patient_images/no_image.png', 'Male', '2020-03-15 12:40:00', '100', '37', '', 'uploads/patient_images/no_image.png', '', 'uploads/patient_images/no_image.png', '', '', '', 'yes', '2020-12-19 07:10:56');
INSERT INTO `birth_report` (`id`, `ref_no`, `opd_ipd_no`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `mother_name`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (4, 'BR19704', '', 'child', 'uploads/birth_image/4/child_img4.php', 'Male', '2020-12-21 13:33:00', '8', '37', '', 'uploads/patient_images/no_image.png', '', 'uploads/patient_images/no_image.png', '', '', '', 'yes', '2020-12-21 08:03:40');


#
# TABLE STRUCTURE FOR: blood_bank_status
#

DROP TABLE IF EXISTS `blood_bank_status`;

CREATE TABLE `blood_bank_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_group` varchar(3) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `ceated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (1, 'A+', '0', '2018-08-18 11:40:07');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (2, 'B+', '0', '2018-08-18 12:10:55');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (3, 'A-', '0', '2018-08-18 12:11:24');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (4, 'B-', '0', '2018-08-18 12:11:44');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (5, 'O+', '0', '2018-08-18 12:12:06');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (6, 'O-', '0', '2018-08-18 12:12:20');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (7, 'AB+', '0', '2018-08-18 12:12:36');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (8, 'AB-', '0', '2018-08-18 12:13:18');


#
# TABLE STRUCTURE FOR: blood_donor
#

DROP TABLE IF EXISTS `blood_donor`;

CREATE TABLE `blood_donor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `donor_name` varchar(100) DEFAULT NULL,
  `age` varchar(11) DEFAULT NULL,
  `month` varchar(20) DEFAULT NULL,
  `blood_group` varchar(11) DEFAULT NULL,
  `gender` varchar(11) DEFAULT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `blood_donor` (`id`, `donor_name`, `age`, `month`, `blood_group`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (1, 'nishu', '25', '6', 'B+', 'Male', 'kartik', 'bhp', '5896896568', '2020-11-13 11:34:57');
INSERT INTO `blood_donor` (`id`, `donor_name`, `age`, `month`, `blood_group`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (2, 'yy', '', '', 'O-', 'Female', '', '', '', '2020-12-02 06:47:04');
INSERT INTO `blood_donor` (`id`, `donor_name`, `age`, `month`, `blood_group`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (3, 'dcxv ', '', '', 'A+', 'Male', 'cxcd', '', 'fdg', '2020-12-29 06:05:32');


#
# TABLE STRUCTURE FOR: blood_donor_cycle
#

DROP TABLE IF EXISTS `blood_donor_cycle`;

CREATE TABLE `blood_donor_cycle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_donor_id` int(11) NOT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `lot` varchar(11) DEFAULT NULL,
  `bag_no` varchar(11) DEFAULT NULL,
  `quantity` varchar(11) DEFAULT NULL,
  `donate_date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: blood_issue
#

DROP TABLE IF EXISTS `blood_issue`;

CREATE TABLE `blood_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `date_of_issue` datetime DEFAULT NULL,
  `recieve_to` varchar(50) DEFAULT NULL,
  `blood_group` varchar(50) DEFAULT NULL,
  `gender` varchar(50) DEFAULT NULL,
  `doctor` varchar(200) DEFAULT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `technician` varchar(50) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `donor_name` varchar(50) DEFAULT NULL,
  `lot` varchar(20) DEFAULT NULL,
  `bag_no` varchar(20) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `generated_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (1, '1', '2020-11-13 17:05:00', '24', NULL, NULL, 'David smith', NULL, '', '500.00', '1', '1', '2145', 'test', '2020-11-13 11:35:43', 1);
INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (2, '2', '2020-11-30 13:09:00', '9', NULL, NULL, 'David smith', NULL, '', '500.00', '1', '', '', '', '2020-11-30 07:40:34', 3);
INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (3, '3', '2020-12-05 16:13:00', '29', NULL, NULL, 'David smith', NULL, '', '1500.00', '1', '2', '1020', '', '2020-12-05 10:49:15', 1);
INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (4, '4', '2020-12-11 17:00:00', '30', NULL, NULL, 'David smith', NULL, '', '20.00', '2', '', '', '', '2020-12-11 11:30:23', 1);
INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (5, '5', '2021-01-05 17:49:00', '43', NULL, NULL, 'David smith', NULL, '', '20.00', '3', '', '', '', '2021-01-05 12:19:39', 1);
INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (6, '6', '2021-01-08 17:26:00', '4', NULL, NULL, 'dfgdfg', NULL, '', '10.00', '3', '', '', '', '2021-01-08 11:57:12', 1);


#
# TABLE STRUCTURE FOR: captcha
#

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userlogin` int(11) NOT NULL DEFAULT '1',
  `login` int(11) NOT NULL DEFAULT '1',
  `appointment` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `captcha` (`id`, `userlogin`, `login`, `appointment`, `created_at`, `updated_at`) VALUES (1, 0, 0, 0, '2020-12-09 04:23:43', NULL);


#
# TABLE STRUCTURE FOR: certificates
#

DROP TABLE IF EXISTS `certificates`;

CREATE TABLE `certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) NOT NULL,
  `certificate_text` text NOT NULL,
  `left_header` varchar(100) NOT NULL,
  `center_header` varchar(100) NOT NULL,
  `right_header` varchar(100) NOT NULL,
  `left_footer` varchar(100) NOT NULL,
  `right_footer` varchar(100) NOT NULL,
  `center_footer` varchar(100) NOT NULL,
  `background_image` varchar(100) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  `created_for` tinyint(1) NOT NULL COMMENT '1 = staff, 2 = patients',
  `status` tinyint(1) NOT NULL,
  `header_height` int(11) NOT NULL,
  `content_height` int(11) NOT NULL,
  `footer_height` int(11) NOT NULL,
  `content_width` int(11) NOT NULL,
  `enable_patient_image` tinyint(1) NOT NULL COMMENT '0=no,1=yes',
  `enable_image_height` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_at`, `updated_at`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`) VALUES (1, 'Sample Medical Certificate', 'This is certify that <b>[patient_name]</b> has born on [dob]  <br> and have following details [year] [month] [gender] [email] [phone] [address] [module_no]', 'Reff. No.....1111111.........', 'To Whomever It May Concern', 'Date: _10__/_10__/__2019__', '.................................<br>admin', '.................................<br>Medical staff', '.................................<br>admin', 'download_(2).png', '2020-11-28 12:44:52', NULL, 2, 1, 360, 400, 480, 810, 0, 0);
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_at`, `updated_at`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`) VALUES (23, 'Medical Certificate test', 'This is certify that <b>[patient_name]</b> has born on [dob]  <br> and have following details [year] [month] [gender] [email] [phone] [address] [module_no]', 'Reff. No.....1111111.........', 'To Whomever It May Concern', 'Date:  __/__/ 20__', '------------</br>admin', '------------</br>Medical Staff', '------------</br>admin', '16.jpg', '2020-12-02 07:40:51', NULL, 2, 1, 360, 400, 480, 810, 0, 0);
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_at`, `updated_at`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`) VALUES (24, 'sdsadasd', 'dsad', 'adsadsad', 'adasdsa', 'dsadsad', '', '', '', 'baby11.jpg', '2020-11-30 10:13:40', NULL, 2, 1, 0, 0, 0, 0, 0, 0);
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_at`, `updated_at`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`) VALUES (25, 'sadasdasdsa', 'asdsadsadsadsad', '', '', '', '', '', '', 'android-rel.jpg', '2020-11-30 10:13:20', NULL, 2, 1, 0, 0, 0, 0, 0, 0);
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_at`, `updated_at`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`) VALUES (26, 'Sample Medical Certificate', '[xyz][14][1993][august][female][rrr@gmai.com][852147963][vihay ngarar]][10]', '  ---------------------------------- <br>Sample Medical Certificate', '         --------------------------------<br> Sample Medical Certificate', '------------------------- <br> Sample Medical Certificate', 'Sample Medical Certificate', 'Sample Medical Certificate', 'Sample Medical Certificate', '16_(9).jpg', '2020-12-02 07:19:30', NULL, 2, 1, 120, 120, 422, 100, 0, 0);
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_at`, `updated_at`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`) VALUES (27, '----------<br>Date of birth', 'garima,1408/1993,female,63748489494490,vijay nagar,12', '---------------Full name', 'middle name', 'Last name', 'fgggg', 'fffh', 'fgfh', '2_(1).jpg', '2020-12-02 07:40:59', NULL, 2, 1, 300, 150, 400, 150, 0, 0);
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_at`, `updated_at`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`) VALUES (29, 'cert', 'text', '', '', '', '', '', '', '1.jpg', '2020-12-21 07:57:33', NULL, 2, 1, 0, 0, 0, 0, 0, 0);


#
# TABLE STRUCTURE FOR: charge_categories
#

DROP TABLE IF EXISTS `charge_categories`;

CREATE TABLE `charge_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `charge_type` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (1, 'OT Charge', 'OT Charge', 'Operation Theatre');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (2, 'Blood checkup', 'Blood checkup', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (3, 'scan', 'scan', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (4, 'Hair Trasplant', 'fdfdsf', 'Procedures');


#
# TABLE STRUCTURE FOR: charge_type_master
#

DROP TABLE IF EXISTS `charge_type_master`;

CREATE TABLE `charge_type_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) CHARACTER SET latin1 NOT NULL,
  `is_default` varchar(100) CHARACTER SET latin1 NOT NULL,
  `is_active` varchar(100) CHARACTER SET latin1 NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (1, 'Procedures', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (2, 'Investigations', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (3, 'Supplier', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (4, 'Operation Theatre', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (5, 'Others', 'yes', 'yes');


#
# TABLE STRUCTURE FOR: charges
#

DROP TABLE IF EXISTS `charges`;

CREATE TABLE `charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) NOT NULL,
  `charge_category` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `code` varchar(100) NOT NULL,
  `standard_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1, 'Investigations', 'Blood checkup', '', 'BC231', '600', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (2, 'Investigations', 'Blood checkup', '', 'BC3215', '700', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (3, 'Investigations', 'scan', '', 'SC12', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (4, 'Operation Theatre', 'OT Charge', '', 'OT11', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (5, 'Procedures', 'Hair Trasplant', 'okk', '40', '5000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (6, 'Procedures', 'Hair Trasplant', '', '015321', '2050', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (7, 'Operation Theatre', 'OT Charge', 'test', '1254', '1000', '0000-00-00', '');


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `source` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `description` text NOT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `image` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `complaint` (`id`, `complaint_type`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`) VALUES (1, 'medicine', '', 'aaaa', '54535435', '', '2021-01-11', 'dfdg fgfg gf', '', '', '', '');
INSERT INTO `complaint` (`id`, `complaint_type`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`) VALUES (2, 'medicine', '', 'fsdf', '79797', '', '2021-01-11', 'Description Description Description', 'Action TakenAction Taken', 'Assigned Assigned Assigned', '', '');


#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (1, 'medicine', '', '2020-12-31 08:52:36');


#
# TABLE STRUCTURE FOR: conference_staff
#

DROP TABLE IF EXISTS `conference_staff`;

CREATE TABLE `conference_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `conference_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (1, '2020-12-05 10:47:21', 4, 2);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (2, '2020-12-05 10:47:21', 4, 3);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (3, '2020-12-05 10:47:21', 4, 4);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (4, '2020-12-05 10:47:21', 4, 5);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (5, '2020-12-05 11:53:04', 6, 2);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (6, '2020-12-05 11:53:04', 6, 3);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (7, '2020-12-05 11:53:17', 7, 2);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (8, '2020-12-05 11:53:17', 7, 3);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (9, '2020-12-05 11:53:17', 7, 4);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (10, '2020-12-05 11:53:17', 7, 5);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (11, '2021-01-05 12:08:42', 10, 2);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (12, '2021-01-05 12:08:42', 10, 3);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (13, '2021-01-05 12:08:42', 10, 4);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (14, '2021-01-05 12:08:42', 10, 5);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (15, '2021-01-05 12:08:42', 10, 6);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (16, '2021-01-05 12:08:42', 10, 7);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (17, '2021-01-05 12:08:42', 10, 8);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (18, '2021-01-05 12:08:42', 10, 9);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (19, '2021-01-05 12:08:42', 10, 10);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (20, '2021-01-05 12:08:42', 10, 11);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (21, '2021-01-05 12:08:42', 10, 12);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (22, '2021-01-05 12:08:42', 10, 13);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (23, '2021-01-05 12:08:42', 10, 14);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (24, '2021-01-05 12:08:42', 10, 15);


#
# TABLE STRUCTURE FOR: conferences
#

DROP TABLE IF EXISTS `conferences`;

CREATE TABLE `conferences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purpose` varchar(200) NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) NOT NULL,
  `opd_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `created_id` int(11) DEFAULT NULL,
  `title` text NOT NULL,
  `date` datetime NOT NULL,
  `duration` int(11) NOT NULL,
  `password` varchar(100) NOT NULL,
  `host_video` int(11) NOT NULL,
  `client_video` int(11) NOT NULL,
  `description` varchar(100) NOT NULL,
  `timezone` varchar(100) NOT NULL,
  `return_response` text CHARACTER SET latin1 NOT NULL,
  `api_type` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `opd_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (1, 'consult', 2, 17, 26, 0, 1, 'Online consult for OPDN26', '2020-12-01 17:36:00', 15, 'ZJ5Pz', 1, 1, '', 'Europe/Dublin', '{\"uuid\":\"yVJ6VRxPQzmheKcprrC0rA==\",\"id\":71666524164,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for OPDN26\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2020-12-05T10:32:26Z\",\"duration\":15,\"timezone\":\"Europe\\/Dublin\",\"created_at\":\"2020-12-05T10:32:26Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/71666524164?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiJnN3dJTDBZX3dvMW9za0cyTk5ENGNyNEJoUTFxaW1sV2cwZW9zOWhfc1dBLkFHLmpfeWlyd2g4ZDRoRlk5elFKU3luSnJmTk1KY0MyU0JvSVEwV1ZfMmplbTNjOFZHemFSS2JiTXFUUnpDbWItUFd6bmdRZjI5enE4QlF5eG5vLkhhX0pwQXNLdW8tMTI1QkFyWU5raEEud29McTY2bkM0VWxCOUMwXyIsImV4cCI6MTYwNzE3MTU0NiwiaWF0IjoxNjA3MTY0MzQ2LCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.Rv_iIlfwRZivW2AHbZaA3FzZjwiYoYoDRTLDaU8sR2w\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/71666524164?pwd=bUJ5WHNobGhyVjhoTGtFWjN6eFk4UT09\",\"password\":\"ZJ5Pz\",\"h323_password\":\"182430\",\"pstn_password\":\"182430\",\"encrypted_password\":\"bUJ5WHNobGhyVjhoTGtFWjN6eFk4UT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false}}}', 'global', 0, '2020-12-05 10:32:27');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `opd_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (2, 'consult', 2, 1, 3, 0, 1, 'test', '2020-12-05 10:39:00', 10, 'PRUVU', 1, 1, '', 'Europe/Dublin', '{\"uuid\":\"+y63Xip9QoS3tIOxb8JDjQ==\",\"id\":74220609437,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"test\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2020-12-05T10:39:00Z\",\"duration\":10,\"timezone\":\"Europe\\/Dublin\",\"created_at\":\"2020-12-05T10:39:35Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/74220609437?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiJQWFpnUkR2eUs2SVNlZFNLdlItVnl3VkFacWZsdjdmcGt0NEpLY09wSzF3LkFHLnQ3aGd5T1IyQTVFeEF5ZjFEcU1ZLU9pVGt6ZGRnaTFtaEViNElVZm44QnptcnR5THNmMGpZLXFYTkVncF9kQkk4ZFdGZlpjYzhRRmdvVk1oLlFUZFBHVFd2TlZiaFZnOFA0SWJOS2cuanVLU2FkdTc3LVBfVUlxMCIsImV4cCI6MTYwNzE3MTk3NSwiaWF0IjoxNjA3MTY0Nzc1LCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.QRnCSEH3MAHwec1qqG4bRUlF-DgJUi_LGAzhhhEe-D8\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/74220609437?pwd=aCtaWXo4Q25CdDBPR0lSdGJUcXNIUT09\",\"password\":\"PRUVU\",\"h323_password\":\"860034\",\"pstn_password\":\"860034\",\"encrypted_password\":\"aCtaWXo4Q25CdDBPR0lSdGJUcXNIUT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false}}}', 'global', 2, '2020-12-05 10:46:21');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `opd_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (3, 'consult', 2, 7, 9, 0, 1, 'nn', '2020-12-05 10:39:00', 10, 'VsqfZ', 1, 1, '', 'Europe/Dublin', '{\"uuid\":\"5+bmUt4hQ5e8DPLIg9RWjw==\",\"id\":77587380797,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"nn\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2020-12-05T10:39:00Z\",\"duration\":10,\"timezone\":\"Europe\\/Dublin\",\"created_at\":\"2020-12-05T10:40:16Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/77587380797?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiIyMldvLWRfOEdEb1J2Q2ZzSTZmYXlxVlFmNmdRQmxISzQwQmJXR085TWwwLkFHLjZLYXNTbFoxVGUtQXJERUdwRjU3UXNxMmt4d3VLLUFTbXhjVkZhV0ZkYjVueXRpSE80Z2wtcTVsaGxJMDFpcUZnc0hqUm5VNm1HVjVjejFoLkRkbFpyeE5pdGE3ZVI4ckZYazVwc3cuMDZZQWFHQWZsc253aUpfSCIsImV4cCI6MTYwNzE3MjAxNiwiaWF0IjoxNjA3MTY0ODE2LCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.-aNoh1pbm4xKO7-dSVUNtOTAd36tDkYRpjqXGKx2-jM\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/77587380797?pwd=dVFIa1ZCMk9PdURrdWhNeFhieVpudz09\",\"password\":\"VsqfZ\",\"h323_password\":\"576011\",\"pstn_password\":\"576011\",\"encrypted_password\":\"dVFIa1ZCMk9PdURrdWhNeFhieVpudz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false}}}', 'global', 2, '2020-12-05 10:46:34');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `opd_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (5, 'consult', 2, 1, 27, 0, 1, 'Online consult for OPDN27', '2020-12-05 17:01:00', 15, 'PUpDB', 1, 1, '', 'Europe/Dublin', '{\"uuid\":\"iDO4qXW\\/QByxdzMBU3iLlA==\",\"id\":76420267724,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for OPDN27\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2020-12-05T17:01:00Z\",\"duration\":15,\"timezone\":\"Europe\\/Dublin\",\"created_at\":\"2020-12-05T11:36:19Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/76420267724?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiJRZ0FtbC1mOGF6UzFEZWNpNkMweERiYW13UE1XbnJCeTZ6bTNIYjkxZ1hVLkFHLkh5cjZIdXBNWm1YMkpza2lNa0Y3ZXJYdUI1S054V1hRdENtV0dreDdZbDNNU3JUcXBFU01KSXY0NW9JRDNRWW1tZ1dNaUZBVmJkbFI0Rm00LmFLUDFNOUpkalFoYllEb19pYU1pblEuYXpmMVZ1dFRIRWRHa0RobSIsImV4cCI6MTYwNzE3NTM3OSwiaWF0IjoxNjA3MTY4MTc5LCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.E3ypaX19rTsUiocwgoQOXWiFqIiQIrdajquYR-gWus4\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/76420267724?pwd=cGdTekI2OXBDYUZRYVliN2syVWVxdz09\",\"password\":\"PUpDB\",\"h323_password\":\"026351\",\"pstn_password\":\"026351\",\"encrypted_password\":\"cGdTekI2OXBDYUZRYVliN2syVWVxdz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false}}}', 'global', 0, '2020-12-05 11:36:19');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `opd_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (6, 'meeting', NULL, 0, 0, 0, 1, 'bb', '2020-12-05 17:18:00', 10, 'AQGSW', 1, 1, 'bbb', 'Europe/Dublin', '{\"uuid\":\"hEp5JI72SeaQNmSNZyPzbA==\",\"id\":71912239754,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"bb\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2020-12-05T17:18:00Z\",\"duration\":10,\"timezone\":\"Europe\\/Dublin\",\"created_at\":\"2020-12-05T11:53:04Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/71912239754?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiJDRnFVM0ZzNVp3SnRucy1hWVRkNTVlU2Q4UDdnN0lScHVJNGltTU9SRmdNLkFHLkJQeVJ1bW5Lc0wxemtvQkllQW1kM0VyUEdVTTJ6Q0dVMWNPX3hRSjIzMVhWc1l2YkJ1OVZ5NURWSjdHVlJCTE50MzRMMGRIRmdYVzI0cG0zLnR0SUR2WFVfelE0RDdkYkhYcEFjVFEuU0p3VGZnM2tzSzFnMXVEMCIsImV4cCI6MTYwNzE3NjM4NCwiaWF0IjoxNjA3MTY5MTg0LCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.40BbWqy7Mlvo_Pgrw6FXFZfcAi1dHbeMfS7aEK_Vkvg\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/71912239754?pwd=cGxidXd0YkxuT0ZZS2JCMERYS3pVZz09\",\"password\":\"AQGSW\",\"h323_password\":\"026844\",\"pstn_password\":\"026844\",\"encrypted_password\":\"cGxidXd0YkxuT0ZZS2JCMERYS3pVZz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false}}}', 'global', 1, '2020-12-05 12:03:15');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `opd_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (7, 'meeting', NULL, 0, 0, 0, 1, 'gggg', '2020-12-05 17:18:00', 15, 'yErhg', 1, 1, '', 'Europe/Dublin', '{\"uuid\":\"9gbTnH62QWq0fW1mqF3ZaQ==\",\"id\":71176791165,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"gggg\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2020-12-05T17:18:00Z\",\"duration\":15,\"timezone\":\"Europe\\/Dublin\",\"created_at\":\"2020-12-05T11:53:17Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/71176791165?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiJ2R3lDamRaRVZpZ0s2bkt3cXdhMldTU1BUdHVQME10THRPX0I4b0lYNDA0LkFHLlRTM2dOclZRRXdlMmdsaFAzdjFFZlZFaFJhekpCcUxlN1gtUHI4TWJ4SnoxWF9qTmlnUW44VC1peURUM2VzUjdONmdGb0RVbS1YOGNwWmRhLmp6YUtpLXAxNHl2Q0JCTmpGcXR0S0Eud0RfcXBnLUpNenhFcEdnUyIsImV4cCI6MTYwNzE3NjM5NywiaWF0IjoxNjA3MTY5MTk3LCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.m80D8u080_0wI8aX0xXfTcoz5wZcO3JFw3GW7qH0L14\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/71176791165?pwd=UlJxZEQvL2krdXRqR2JqSDVBQW4yQT09\",\"password\":\"yErhg\",\"h323_password\":\"212367\",\"pstn_password\":\"212367\",\"encrypted_password\":\"UlJxZEQvL2krdXRqR2JqSDVBQW4yQT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false}}}', 'global', 0, '2020-12-05 11:53:17');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `opd_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (8, 'consult', 2, 34, 16900, 0, 1, 'Online consult for OPDN16900', '2020-12-29 14:58:00', 15, 'WksVM', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"P85zpL31TeyIQDWaKKy4eQ==\",\"id\":71232883500,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for OPDN16900\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2020-12-29T03:58:00Z\",\"duration\":15,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2020-12-28T09:32:19Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/71232883500?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiJyX0lNbmRndkY3RVhuT2xJM3IzbUFXNWdTbFRkbzRYNThNZjN6NTQyb3MwLkFHLmMzb3BvUlJKVks3eU1uVzVaVXNZcTZibVVKSHpTOVlWdFY0RjVwVVhuZlZDSlJtQVlFSHlGS3Nfbzdqck00NGRqSHdOeTA3NXpqTTN0NGJTLkdocXNvOFRyWVUwVVlqc04ta0x4ZlEuSUQ5VTgzR21FOU1pQS1RYyIsImV4cCI6MTYwOTE1NTEzOSwiaWF0IjoxNjA5MTQ3OTM5LCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.Xk3ljD1pUyXSUqOrUC_Li18YRodb1p4vKZuDslwejMQ\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/71232883500?pwd=QXJBc2RnWGdUU3k0UEFmVVZnNXRwUT09\",\"password\":\"WksVM\",\"h323_password\":\"612532\",\"pstn_password\":\"612532\",\"encrypted_password\":\"QXJBc2RnWGdUU3k0UEFmVVZnNXRwUT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false}}}', 'global', 0, '2020-12-28 09:32:19');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `opd_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (9, 'consult', 2, 34, 16901, 0, 1, 'Online consult for Recheckup OPDN16901', '2020-12-29 15:03:00', 15, 'fLhnq', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"ds\\/Z4jTMQlGgP8z6AMymtw==\",\"id\":72709548232,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Recheckup OPDN16901\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2020-12-29T04:03:00Z\",\"duration\":15,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2020-12-28T09:36:45Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/72709548232?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiJmTnVtc1hSQzBNeXk4WUtSQ25ab19EQXdTWU5rVWZ6ckx1X3J0OUhKbXgwLkFHLkhHR1NZd1RfVGswcU9XTDg2TUFoNGhRaF9lNnBqTWxha1ZhbXQzTzZNd2h2M1R3bW4xX0ViejVjcElTc0lwSzgwVHA4eTZTVVpjUjFnS1dZLkYxUVRxNkpZNkxpdVBrclRYbkw3eEEuTkt6VElrVVYteWxGVjNOayIsImV4cCI6MTYwOTE1NTQwNSwiaWF0IjoxNjA5MTQ4MjA1LCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.uNZV7Ygne846KGuLpAzaZLPzTPhbKJXQ69EXEWRh-bk\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/72709548232?pwd=eHc2VTErejk3STljanB3YTN6VU0ydz09\",\"password\":\"fLhnq\",\"h323_password\":\"473120\",\"pstn_password\":\"473120\",\"encrypted_password\":\"eHc2VTErejk3STljanB3YTN6VU0ydz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false}}}', 'global', 0, '2020-12-28 09:36:45');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `opd_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (10, 'meeting', NULL, 0, 0, 0, 1, 'ddsdfv', '2021-01-05 17:32:00', 40, 'rkyLJ', 1, 1, 'fgrfgr', 'Asia/Kolkata', '{\"uuid\":\"2vdceIHGQQuiMwELf7Ix9A==\",\"id\":79063868631,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"ddsdfv\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-01-05T12:08:42Z\",\"duration\":40,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-01-05T12:08:42Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/79063868631?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiJwdUpXSnRPR1VLNW5PVUlySW95MnE1cEJaeE9nR19vc3lWa2NZOGZneEJZLkFHLkdfVnFlRFJNWkpJUERtbkMwZWdZekpDd0JCcVN0OW9TZXl6S1piZWo0SE50SjltcGVyWFFXZVlDb0dibWUxVTRDTVJHYW5iZlJEVmd4bUdFLi14ZTFsYVpiQ3QxQl9rUXhsd1Z1MncuSUpDTkxjNHNta3k1enJVTyIsImV4cCI6MTYwOTg1NTcyMiwiaWF0IjoxNjA5ODQ4NTIyLCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.4ltPLPQcrZa45FatGfBIPyfo3g23Tetf_Lllvx0voaI\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/79063868631?pwd=bUFlbk85a3BxOHNqSE8vdG1XVWFzZz09\",\"password\":\"rkyLJ\",\"h323_password\":\"186521\",\"pstn_password\":\"186521\",\"encrypted_password\":\"bUFlbk85a3BxOHNqSE8vdG1XVWFzZz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false}}}', 'global', 0, '2021-01-05 12:08:42');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `opd_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (11, 'consult', 2, 19, 24, 0, 1, 'ghfgjg', '2021-01-06 13:00:00', 40, '5bnj8', 1, 1, 'jhk,jk', 'Asia/Kolkata', '{\"uuid\":\"TYHAVpZiRd2gWdPQ9jJZGA==\",\"id\":79648770822,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"ghfgjg\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-01-06T07:30:46Z\",\"duration\":40,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-01-06T07:30:46Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/79648770822?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiJyN01lMUdfLTh3M2dfZUlVbU5UXzdXREl5ZnJGcC1MamZBMUVMOHprdE1FLkFHLjhJZGRkUU1oLXY5V2VUYmJCVUYxN1F2UjJhR3ZYZ2VORnZsYmpzNXRZaWRuaGh4aEFjUUZzVUlKNEpnRmJOb3VtcGpBd01QODA3WkZhWGxXLlMtSDluVWI4VXlnczN5dHhuendsUmcuaFdHOHhCVkdrUnZ0TGViUSIsImV4cCI6MTYwOTkyNTQ0NiwiaWF0IjoxNjA5OTE4MjQ2LCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.PRpZU4dPu5z25OAwyFDn28-5Y5jBuZMedbwvHtK6vtk\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/79648770822?pwd=bTJIa0ZBUjlDdUpwc2tSVTRsUC81QT09\",\"password\":\"5bnj8\",\"h323_password\":\"192010\",\"pstn_password\":\"192010\",\"encrypted_password\":\"bTJIa0ZBUjlDdUpwc2tSVTRsUC81QT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false}}}', 'global', 0, '2021-01-06 07:30:47');


#
# TABLE STRUCTURE FOR: conferences_history
#

DROP TABLE IF EXISTS `conferences_history`;

CREATE TABLE `conferences_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `total_hit` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `conferences_history` (`id`, `conference_id`, `staff_id`, `patient_id`, `total_hit`, `created_at`) VALUES (1, 3, 0, 7, 0, '2020-12-05 10:45:07');


#
# TABLE STRUCTURE FOR: consult_charges
#

DROP TABLE IF EXISTS `consult_charges`;

CREATE TABLE `consult_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor` int(11) NOT NULL,
  `standard_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`) VALUES (1, 2, '300', '0000-00-00', '');


#
# TABLE STRUCTURE FOR: consultant_register
#

DROP TABLE IF EXISTS `consultant_register`;

CREATE TABLE `consultant_register` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `date` varchar(100) DEFAULT NULL,
  `ins_date` varchar(50) DEFAULT NULL,
  `instruction` text NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (1, 4, 4, '2020-11-24 12:32:00', '2020-11-24', 'dfgdfgdfg\r\ndfgdfgdfgdfg\r\ndfgdfgdfg\r\ndfg\r\ndfg\r\ndfg\r\nd\r\nfg\r\ndfg', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (2, 2, 6, '2020-11-27 14:43:00', '2020-11-27', 'test instruction', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (3, 2, 6, '2020-11-26 14:43:00', '2020-11-26', 'Instruction  1', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (4, 2, 6, '2020-11-27 14:43:00', '2020-11-27', 'Instruction  2', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (5, 2, 6, '2020-11-28 14:43:00', '2020-11-28', 'Instruction 3', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (6, 19, 7, '2020-11-30 17:47:00', '2020-11-30', 'ndgfgff', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (7, 19, 7, '2020-12-07 22:16:00', '2020-12-07', '23', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (8, 19, 7, '2020-12-08 17:34:00', '2020-12-08', 'dfgdfg\r\ndfgdfg\r\ndfgdfg', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (9, 0, 6115, '2020-12-16 16:13:00', '2020-12-16', 'gdfgdfg\r\ndfgdfgfd', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (12, 35, 10, '2020-12-22 17:33:00', '2020-12-22', 'trstttt hhhhh', 5);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (13, 35, 10, '2020-12-22 18:05:00', '2020-12-22', 'test\r\ntest1\r\ntest2\r\nfdsfdf', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (14, 19, 7, '2020-12-23 10:29:00', '2020-12-24', 'fhf fdfgd dg d', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (15, 1, 11, '2020-12-23 14:14:00', '2020-12-23', 'test ins', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (16, 19, 7, '2020-12-24 10:52:00', '2020-12-24', '-1\r\n\r\n\r\nI would like to make a site where a popup appears once in 24h for every unique user. For this I use bPopup and cookies. I have tried lot of things and for now I am kind of \"lost\" in the code. ', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (17, 19, 7, '2020-12-24 10:58:00', '2020-12-24', '-1\r\n\r\n\r\nI would like to make a site where a popup appears once in 24h for every unique user. For this I use bPopup and cookies. I have tried lot of things and for now I am kind of \"lost\" in the code. ', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (18, 19, 7, '2020-12-25 13:55:00', '2020-12-25', 'I would like to make a site where a popup appears once in 24h for every unique user. For this I use bPopup and cookies. I have tried lot of things and for now I am kind of \"lost\" in the code. Could yo', 4);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (19, 35, 10, '2021-01-06 17:34:00', '2021-01-06', 'zxzc', 2);


#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `file` varchar(250) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `note` text,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (1, 'test content', 'ffffff', 'No', 'uploads/hospial_content/material/1.png', 0, 'fffffffffdfdgfdg', 'no', '2021-01-12 07:58:20', '2021-01-08');


#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `belong_table_id` int(11) DEFAULT NULL,
  `custom_field_id` int(11) DEFAULT NULL,
  `field_value` varchar(200) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`)
) ENGINE=InnoDB AUTO_INCREMENT=185 DEFAULT CHARSET=utf8;

INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1, 1, 1, 'gcbgdngggg', '2020-12-02 07:45:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2, 1, 3, '', '2020-12-02 07:47:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3, 1, 4, '', '2020-12-02 07:47:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4, 2, 1, 'bbb cccc', '2020-12-19 07:13:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (5, 2, 2, 'bbbb cccc', '2020-12-19 07:13:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (6, 34, 6, '12-14-2020 6:41 PM', '2020-12-14 13:12:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (7, 34, 5, 'sddfdsfdssdfsdf', '2020-12-14 13:12:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (8, 35, 8, 'aaacccc', '2020-12-15 12:58:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (9, 35, 6, '12-23-2020 12:00 PM', '2020-12-15 06:30:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (10, 35, 5, 'dssdaasda', '2020-12-15 06:30:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (11, 2, 7, 'ttttt', '2020-12-15 11:55:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (12, 36, 8, '', '2020-12-15 08:48:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (13, 36, 6, '', '2020-12-15 08:48:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (14, 36, 5, '', '2020-12-15 08:48:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (15, 36, 9, 'sdsdssadd', '2020-12-16 10:49:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (16, 37, 8, 'dddd', '2020-12-16 11:01:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (17, 37, 6, '12-16-2020 4:31 PM', '2020-12-16 11:01:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (18, 37, 5, 'ssssss', '2020-12-16 11:01:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (19, 4, 9, 'sssssssssssss', '2020-12-16 11:33:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (20, 10, 9, 'jhgjhggjh', '2020-12-16 12:29:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (21, 3, 13, 'sssssss', '2020-12-17 10:13:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (22, 2, 14, 'aaaaaaaa', '2020-12-17 11:54:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (23, 5, 14, 'bhp fffff', '2021-01-07 12:36:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (24, 6, 14, 'jabalpur', '2020-12-18 06:33:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (25, 2, 0, NULL, '2020-12-18 07:01:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (26, 2, 15, 'gggggg cccc', '2020-12-19 07:13:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (27, 2, 3, 'aAaadssa', '2020-12-18 07:31:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (28, 2, 4, 'ddgdddgdgdgdgd', '2020-12-18 07:31:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (29, 34, 16, 'aaaaaaaaa', '2020-12-18 09:09:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (30, 30, 16, 'aabbcc', '2020-12-19 09:13:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (31, 35, 16, 'ttttttqqqqq', '2020-12-18 11:43:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (32, 33, 16, 'aaaaawww', '2020-12-18 12:23:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (33, NULL, 17, 'rrrrrrrrrrr', '2020-12-18 10:22:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (34, 3, 17, 'gggggg', '2020-12-18 11:34:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (35, 25, 18, 'ddddddddddddrrrr', '2020-12-19 07:10:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (36, 3, 1, 'dfgdfgdfg dfg d', '2020-12-19 07:10:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (37, 3, 2, ' dfgdf gdfg dfg', '2020-12-19 07:10:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (38, 3, 15, 'ghfghfghfgh fgh', '2020-12-19 07:10:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (39, 26, 18, 'trteteeetertttddd', '2020-12-19 07:19:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (40, 4, 1, '', '2020-12-21 08:03:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (41, 4, 2, '', '2020-12-21 08:03:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (42, 4, 15, 'test', '2020-12-21 08:03:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (43, 2, 10, 'Staff custom', '2020-12-22 07:08:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (44, 2, 19, 'tttttttttaaaaa', '2020-12-22 07:35:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (45, 3, 21, 'vishnu', '2021-01-05 16:21:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (46, 7, 10, '', '2020-12-22 10:36:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (47, 4, 10, '', '2020-12-22 10:41:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (48, 13, 22, 'test custom fields dffddddf', '2020-12-28 08:36:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (49, 14, 22, 'fddfgdf fg dg', '2020-12-23 05:00:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (50, 8, 10, '', '2020-12-23 07:17:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (51, 11, 9, 'test ipd field', '2020-12-23 07:42:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (52, 2, 23, 'test custom fields', '2020-12-23 08:44:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (53, 15, 22, 'custom test value', '2020-12-23 08:45:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (54, 3, 23, 'test custom', '2020-12-23 09:27:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (55, NULL, 24, 'tyrtryrtyrtrytr', '2020-12-23 11:52:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (56, 6, 24, 'fffffff', '2020-12-23 12:00:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (57, 16, 22, '-1   I would like to make a site where a popup appears once in 24h for every unique user. For this I use bPopup and cookies. I have tried lot of things and for now I am kind of \"lost\" in the code. Cou', '2020-12-24 05:22:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (58, 4, 23, 'custom fields', '2020-12-25 12:34:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (59, 17, 22, '-1   I would like to make a site where a popup appears once in 24h for every unique user. For this I use bPopup and cookies. I have tried lot of things and for now I am kind of \"lost\" in the code. Cou', '2020-12-24 05:28:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (60, 18, 22, 'retrertet', '2020-12-25 08:25:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (61, 19, 22, 'ddddadsddasdadsdasd', '2020-12-25 08:29:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (62, 5, 23, 'nnnnnnnnnnnnqqqqq', '2020-12-25 12:32:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (63, 6, 23, 'Note test Note test Note test Note test Note test Note test Note test Note test Note test Note test Note test Note test Note test Note test Note test Note test Note test Note test Note test Note test', '2020-12-25 13:01:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (64, 7, 23, 'test custom fields text', '2020-12-26 04:38:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (65, 8, 23, 'as ad asdas as asdasd', '2020-12-26 04:51:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (66, 1, 23, 'test custom fields', '2020-12-26 05:55:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (67, 9, 10, '', '2020-12-26 09:42:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (68, 2, 23, 'fsd fdf fsdfdsf', '2020-12-26 09:42:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (69, 4, 25, 'ttttttttttttttttttccccccccccc', '2020-12-26 12:24:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (70, 5, 25, 'text custom fields', '2020-12-28 09:36:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (71, 6, 25, 'tttttttttttttttttt rrrrrrrrrrrrr', '2020-12-28 08:46:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (72, 27, 18, '101', '2020-12-28 06:08:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (73, 16899, 16, 'bmb', '2020-12-28 07:55:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (74, 12, 9, 'nvn', '2020-12-28 08:00:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (75, 12, 22, 'fgfgffgfg', '2020-12-28 08:37:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (76, 16900, 16, '100', '2020-12-28 09:32:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (77, 16901, 16, '100', '2020-12-28 09:33:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (78, NULL, 17, '102', '2020-12-28 09:36:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (79, 38, 8, 'ad', '2020-12-28 09:53:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (80, 38, 6, '', '2020-12-28 09:53:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (81, 38, 5, 'jkhk', '2020-12-28 09:53:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (82, 39, 8, 'ds', '2020-12-28 10:32:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (83, 39, 6, '', '2020-12-28 10:32:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (84, 39, 5, 'cv', '2020-12-28 10:32:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (85, 40, 8, 'cv', '2020-12-28 10:34:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (86, 40, 6, '', '2020-12-28 10:34:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (87, 40, 5, 'dfg', '2020-12-28 10:34:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (88, 13, 9, '', '2020-12-28 10:46:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (89, 7, 25, 'ddddddddd', '2020-12-28 12:51:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (90, 8, 25, 'dsadasdsad gg', '2020-12-28 12:58:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (91, 9, 25, 'ssdsdsd', '2020-12-28 13:00:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (92, 10, 25, 'fffffff', '2020-12-28 13:03:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (93, 11, 25, 'ssssssss', '2020-12-29 05:37:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (94, 12, 25, 'sssssssss', '2020-12-29 05:37:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (95, 13, 25, 'fffffffff', '2020-12-29 05:45:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (96, 4, 13, 'dfdg', '2020-12-29 05:56:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (97, 5, 13, 'cxcxv', '2020-12-29 05:57:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (98, 7, 24, 'fcbhfcgghbf', '2020-12-29 05:58:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (99, 8, 24, 'kjl', '2020-12-29 05:59:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (100, 14, 25, 'custom field', '2020-12-29 07:05:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (101, 3, 19, '500', '2020-12-29 07:17:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (102, 7, 14, 'Jabalpur', '2020-12-29 07:29:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (103, 8, 14, 'jabalpur ssdsdss', '2021-01-07 12:36:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (104, 6, 10, '', '2020-12-29 10:12:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (105, 10, 10, '', '2020-12-29 11:17:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (106, 11, 10, '', '2020-12-29 11:18:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (107, 12, 10, '', '2020-12-29 11:18:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (108, 13, 10, '', '2020-12-29 11:20:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (109, 14, 10, '', '2020-12-30 05:57:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (110, 15, 10, '', '2020-12-30 07:22:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (111, 41, 8, 'aqs', '2020-12-31 07:20:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (112, 41, 6, '', '2020-12-31 07:20:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (113, 41, 5, 'aszs', '2020-12-31 07:20:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (114, 42, 8, 'custom field', '2020-12-31 08:43:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (115, 42, 6, '', '2020-12-31 08:43:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (116, 42, 5, 'test', '2020-12-31 08:43:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (117, 43, 8, 'ddd', '2021-01-01 12:47:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (118, 43, 6, '', '2021-01-01 12:47:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (119, 43, 5, 'ddd', '2021-01-01 12:47:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (120, 16902, 16, '', '2021-01-01 12:49:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (121, 16903, 16, '', '2021-01-05 05:55:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (122, 16904, 16, '', '2021-01-05 05:57:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (123, 16905, 16, '', '2021-01-05 06:08:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (124, 16906, 16, '', '2021-01-05 06:14:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (125, 16907, 16, '', '2021-01-05 06:41:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (126, 16908, 16, '', '2021-01-05 07:04:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (127, 16909, 16, '', '2021-01-05 11:36:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (128, 6, 13, 'dfgdfg', '2021-01-05 12:13:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (129, 7, 13, 'nm', '2021-01-05 12:16:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (130, 2, 21, 'ram', '2021-01-05 16:20:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (131, 1, 21, 'shyam', '2021-01-05 16:20:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (132, 4, 21, 'sdfsdfs', '2021-01-05 16:43:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (133, 5, 21, 'sdfsd', '2021-01-05 16:44:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (134, 6, 21, 'sdfdsfsf', '2021-01-05 16:46:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (135, 7, 21, 'king', '2021-01-05 16:47:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (136, 8, 21, 'rraaa', '2021-01-05 16:50:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (137, 9, 21, '1010', '2021-01-05 16:52:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (138, 10, 21, 'Test expenses *Test expenses *Test expenses * jjjjjjjjjjjjjj', '2021-01-06 04:45:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (139, 11, 21, 'Test expenses *Test expenses *', '2021-01-06 04:59:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (140, 4, 19, 'ffffffdfgfg fgfg', '2021-01-06 08:44:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (141, 5, 19, 'ffff', '2021-01-06 09:39:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (142, 5, 27, 'fffff', '2021-01-06 09:39:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (143, 19, 22, 'cvfcvg', '2021-01-06 12:06:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (144, 15, 25, '', '2021-01-06 12:15:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (145, 16, 25, '', '2021-01-06 12:29:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (146, 1, 26, 'Field NameField NameField NameField NameField NameField NameField NameField NameField NameField NameField NameField NameField NameField NameField NameField NameField NameField NameField NameField Name', '2021-01-07 05:01:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (147, 10, 26, 'Field Name', '2021-01-07 05:02:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (148, 9, 26, 'Field Name *', '2021-01-07 05:02:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (149, 1, 11, 'gggggg', '2021-01-07 08:01:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (150, 8, 13, 'eeeee', '2021-01-07 10:11:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (151, 10, 28, '', '2021-01-07 10:34:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (152, 9, 13, 'sdsdsd dsdsd', '2021-01-07 11:00:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (153, 37, 18, 'xvcvcxv', '2021-01-07 11:20:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (154, 38, 18, 'gfdgfdgdf', '2021-01-07 11:21:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (155, 41, 18, 'fsfdf', '2021-01-08 11:47:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (156, 44, 18, 'sdfsdf', '2021-01-08 12:20:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (157, 16910, 16, '', '2021-01-08 11:56:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (158, 45, 18, 'fffffffffffffffffffffddddddd yyyy', '2021-01-15 07:18:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (159, 46, 18, 'test', '2021-01-09 06:55:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (160, 47, 18, 'tst gff', '2021-01-15 07:18:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (161, 48, 18, 'test', '2021-01-09 07:11:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (162, 52, 8, 'hfgh', '2021-01-12 06:39:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (163, 52, 6, '12-1-2021 12:09 PM', '2021-01-12 06:39:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (164, 52, 5, 'fghfgh', '2021-01-12 06:39:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (165, 12, 21, 'dfgdfg', '2021-01-12 06:40:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (166, 12, 26, 'dfgdf', '2021-01-12 06:40:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (167, 12, 28, 'dfgdfg', '2021-01-12 06:40:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (168, 60, 18, 'test', '2021-01-14 06:51:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (169, 14, 9, '', '2021-01-14 10:22:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (170, 54, 8, 'fgfddf', '2021-01-15 07:03:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (171, 54, 6, '14-1-2021 12:32 PM', '2021-01-15 07:03:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (172, 54, 5, 'dgdfgdf', '2021-01-15 07:03:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (173, NULL, 17, 'fdfd', '2021-01-15 12:15:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (174, NULL, 17, 'dfdfdsfdfdfds', '2021-01-16 06:36:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (175, 63, 18, 'test', '2021-01-16 10:34:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (176, NULL, 17, 'sdsd', '2021-01-16 11:04:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (177, 16911, 16, '', '2021-01-16 11:55:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (178, NULL, 17, 'gggffgff', '2021-01-16 11:56:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (179, 7, 17, 'ddddd', '2021-01-16 12:50:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (180, NULL, 17, 'dfsdfdsf', '2021-01-18 07:41:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (181, 3, 10, '', '2021-01-18 11:53:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (182, 16912, 16, '', '2021-01-19 05:11:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (183, 17, 25, 'test', '2021-01-19 05:35:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (184, 18, 25, '<script></script>', '2021-01-19 05:37:16');


#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int(10) DEFAULT NULL,
  `validation` int(11) DEFAULT '0',
  `field_values` mediumtext,
  `visible_on_print` int(11) DEFAULT NULL,
  `visible_on_table` int(11) NOT NULL,
  `weight` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (1, 'helo9', 'birth_report', 'textarea', 3, 1, '', 1, 0, NULL, 0, '2021-01-12 07:32:32');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (2, 'teststststsss', 'birth_report', 'input', 3, 0, '', 1, 0, NULL, 0, '2020-12-19 07:09:06');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (3, 'ffffff', 'death_report', 'input', 12, 0, '', NULL, 0, NULL, 0, '2021-01-12 07:32:46');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (4, 'tersrttt', 'death_report', 'textarea', 7, 1, '', 1, 1, NULL, 0, '2020-12-19 07:13:24');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (5, 'test', 'patient', 'textarea', 12, 1, 'Testing values', NULL, 1, 3, 0, '2021-01-15 08:57:00');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (6, 'date time', 'patient', 'date_picker_time', 12, 0, 'date time', NULL, 0, 1, 0, '2020-12-16 12:25:37');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (8, 'Field Name', 'patient', 'input', 3, 1, '', NULL, 1, 2, 0, '2021-01-15 08:57:00');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (9, 'ipd field', 'ipd', 'input', 12, 0, '', NULL, 0, NULL, 0, '2021-01-12 07:30:40');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (10, 'staff custom', 'staff', 'input', 2, 0, '', NULL, 0, NULL, 0, '2021-01-12 07:29:58');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (11, 'test patology', 'pathology', 'input', 12, 1, '', NULL, 1, NULL, 0, '2021-01-12 07:31:33');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (12, 'test radiology', 'radiology', 'input', 12, 1, '', NULL, 1, NULL, 0, '2021-01-12 07:31:45');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (13, 'test ot', 'operationtheatre', 'input', 12, 1, '', NULL, 1, NULL, 0, '2021-01-12 07:32:00');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (14, 'custom address', 'ambulance', 'input', 12, 1, '', NULL, 1, NULL, 0, '2021-01-12 07:32:20');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (15, 'testbirth', 'birth_report', 'input', 3, 1, '', 0, 1, NULL, 0, '2020-12-19 07:09:18');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (16, 'opd test', 'opd', 'input', 4, 0, '', NULL, 1, NULL, 0, '2021-01-12 07:30:14');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (17, 'recheckup opd', 'opdrecheckup', 'input', 6, 1, '', NULL, 0, NULL, 0, '2021-01-12 07:30:26');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (18, 'appointment test', 'appointment', 'input', 3, 1, '', NULL, 1, NULL, 0, '2021-01-12 06:51:57');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (19, 'test income', 'income', 'input', 12, 1, '', NULL, 1, NULL, 0, '2021-01-12 07:33:00');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (21, 'test expenses', 'expenses', 'input', 12, 1, '', NULL, 1, NULL, 0, '2021-01-12 07:33:17');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (22, 'test consultant', 'ipdconsultinstruction', 'input', 12, 1, '', NULL, 1, NULL, 0, '2021-01-12 07:30:51');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (24, 'test ot consultant', 'otconsultinstruction', 'input', 12, 1, '', NULL, 1, NULL, 0, '2021-01-12 07:32:11');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (25, 'test note', 'ipdnursenote', 'input', 12, 0, '', NULL, 0, NULL, 0, '2021-01-12 07:31:07');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (26, 'Field Name', 'expenses', 'input', 3, 1, 'Validation Validation Validation Validation Validation Validation', NULL, 1, NULL, 0, '2021-01-06 12:42:00');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (27, 'demo', 'income', 'input', 12, 1, '', NULL, 1, NULL, 0, '2021-01-06 09:37:31');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (28, 'testing', 'expenses', 'input', 3, 0, 'sdfsdf', NULL, 1, NULL, 0, '2021-01-07 05:11:12');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (29, 'test custom', 'pharmacy', 'input', 12, 1, '', NULL, 1, NULL, 0, '2021-01-12 07:31:22');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (30, 'lets', 'pathology', 'input', 12, 1, '', NULL, 1, NULL, 0, '2021-01-14 11:56:38');


#
# TABLE STRUCTURE FOR: death_report
#

DROP TABLE IF EXISTS `death_report`;

CREATE TABLE `death_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `opdipd_no` varchar(200) NOT NULL,
  `patient` varchar(200) NOT NULL,
  `gender` varchar(50) NOT NULL,
  `image` varchar(200) NOT NULL,
  `death_date` datetime NOT NULL,
  `guardian_name` varchar(200) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `address` varchar(200) NOT NULL,
  `death_report` text NOT NULL,
  `is_active` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `death_report` (`id`, `opdipd_no`, `patient`, `gender`, `image`, `death_date`, `guardian_name`, `contact`, `address`, `death_report`, `is_active`, `created_at`) VALUES (1, '1020', '18', '', '', '2020-12-02 13:11:00', 'nnn', '', '', 'hghjhgjgj', 'yes', '2020-12-18 07:31:47');
INSERT INTO `death_report` (`id`, `opdipd_no`, `patient`, `gender`, `image`, `death_date`, `guardian_name`, `contact`, `address`, `death_report`, `is_active`, `created_at`) VALUES (2, '', '22', '', '', '2020-12-18 13:00:00', 'gggg', '', '', '', 'yes', '2020-12-18 07:35:04');


#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: diagnosis
#

DROP TABLE IF EXISTS `diagnosis`;

CREATE TABLE `diagnosis` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `report_type` varchar(200) NOT NULL,
  `document` varchar(200) NOT NULL,
  `description` varchar(400) NOT NULL,
  `report_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (1, 19, 'Hyroid', '', 'na\r\nhkhjkjk\r\njhkhjkjh', '2020-11-30');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (2, 2, 'dadasd', '', 'dasdasd', '2020-12-31');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (3, 19, 'ghdfhg', '', 'fgdfg \r\nghfg\r\ngdfg', '2020-12-09');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (4, 19, 'dfgdf', '', 'dfgdf\r\ngdfgd\r\nhfghdg', '2020-12-08');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (5, 37, 'vcbxvx', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (6, 37, 'Normal', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (7, 4, 'hhh', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (9, 4, 'test', '', 'ffffffffffffff', '2021-01-13');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (10, 43, 'test', '', 'rrrrrrrrr', '2021-01-13');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (11, 43, 'sssss', '', 'dsdsd', '2021-01-06');


#
# TABLE STRUCTURE FOR: discharged_summary
#

DROP TABLE IF EXISTS `discharged_summary`;

CREATE TABLE `discharged_summary` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `operation` varchar(200) CHARACTER SET latin1 NOT NULL,
  `diagnosis` varchar(200) CHARACTER SET latin1 NOT NULL,
  `note` text CHARACTER SET latin1 NOT NULL,
  `investigations` text CHARACTER SET latin1 NOT NULL,
  `treatment_home` text CHARACTER SET latin1 NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: discharged_summary_opd
#

DROP TABLE IF EXISTS `discharged_summary_opd`;

CREATE TABLE `discharged_summary_opd` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `opd_id` int(11) NOT NULL,
  `operation` varchar(200) CHARACTER SET latin1 NOT NULL,
  `diagnosis` varchar(200) CHARACTER SET latin1 NOT NULL,
  `note` text CHARACTER SET latin1 NOT NULL,
  `investigations` text CHARACTER SET latin1 NOT NULL,
  `treatment_home` text CHARACTER SET latin1 NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `discharged_summary_opd` (`id`, `patient_id`, `opd_id`, `operation`, `diagnosis`, `note`, `investigations`, `treatment_home`, `created_at`) VALUES (1, 17, 19, '', '', '', '', '', '2020-11-30 12:00:08');


#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `address` varchar(500) NOT NULL,
  `note` varchar(500) NOT NULL,
  `from_title` varchar(200) NOT NULL,
  `date` varchar(20) NOT NULL,
  `image` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `type`) VALUES (3, '3424', 'test', '', 'sdsds', '', '2021-01-12', '', '2021-01-12 06:48:08', 'dispatch');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `type`) VALUES (4, '4235', 'gggggg', 'bhp', 'gffhghgfh', 'test', '2021-01-11', '', '2021-01-11 06:56:29', 'receive');


#
# TABLE STRUCTURE FOR: doctor_absent
#

DROP TABLE IF EXISTS `doctor_absent`;

CREATE TABLE `doctor_absent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: doctor_global_shift
#

DROP TABLE IF EXISTS `doctor_global_shift`;

CREATE TABLE `doctor_global_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor_id` int(11) NOT NULL,
  `global_shift_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `doctor_global_shift_ibfk1` (`global_shift_id`),
  CONSTRAINT `doctor_global_shift_ibfk1` FOREIGN KEY (`global_shift_id`) REFERENCES `global_shift` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8;

INSERT INTO `doctor_global_shift` (`id`, `doctor_id`, `global_shift_id`, `created_at`) VALUES (9, 4, 2, '2021-01-15 07:51:53');
INSERT INTO `doctor_global_shift` (`id`, `doctor_id`, `global_shift_id`, `created_at`) VALUES (15, 2, 1, '2021-01-15 10:04:02');
INSERT INTO `doctor_global_shift` (`id`, `doctor_id`, `global_shift_id`, `created_at`) VALUES (23, 11, 2, '2021-01-15 12:49:54');
INSERT INTO `doctor_global_shift` (`id`, `doctor_id`, `global_shift_id`, `created_at`) VALUES (28, 5, 1, '2021-01-15 12:50:23');
INSERT INTO `doctor_global_shift` (`id`, `doctor_id`, `global_shift_id`, `created_at`) VALUES (29, 7, 2, '2021-01-15 12:50:25');
INSERT INTO `doctor_global_shift` (`id`, `doctor_id`, `global_shift_id`, `created_at`) VALUES (37, 10, 1, '2021-01-15 12:54:30');
INSERT INTO `doctor_global_shift` (`id`, `doctor_id`, `global_shift_id`, `created_at`) VALUES (40, 12, 1, '2021-01-15 12:54:50');
INSERT INTO `doctor_global_shift` (`id`, `doctor_id`, `global_shift_id`, `created_at`) VALUES (41, 14, 1, '2021-01-15 12:54:51');
INSERT INTO `doctor_global_shift` (`id`, `doctor_id`, `global_shift_id`, `created_at`) VALUES (42, 13, 2, '2021-01-15 12:54:52');
INSERT INTO `doctor_global_shift` (`id`, `doctor_id`, `global_shift_id`, `created_at`) VALUES (43, 15, 2, '2021-01-15 12:54:53');
INSERT INTO `doctor_global_shift` (`id`, `doctor_id`, `global_shift_id`, `created_at`) VALUES (83, 2, 9, '2021-01-18 08:46:35');


#
# TABLE STRUCTURE FOR: doctor_shift
#

DROP TABLE IF EXISTS `doctor_shift`;

CREATE TABLE `doctor_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` varchar(20) CHARACTER SET latin1 DEFAULT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `global_shift_id` int(11) NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `doctor_shift_ibfk1` (`global_shift_id`),
  CONSTRAINT `doctor_shift_ibfk1` FOREIGN KEY (`global_shift_id`) REFERENCES `global_shift` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `doctor_shift` (`id`, `day`, `doctor_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (1, 'Monday', 2, 1, '11:59:00', '12:34:00', '2021-01-18 10:28:02');


#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `smtp_auth` varchar(10) NOT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_username`, `smtp_password`, `ssl_tls`, `smtp_auth`, `is_active`, `created_at`) VALUES (2, 'sendmail', 'smtp.gmail.com', '587', 'smtpwebfebtest@gmail.com', 'higdadoxyjtlibxl', 'tls', 'true', 'yes', '2021-01-19 05:41:41');


#
# TABLE STRUCTURE FOR: enquiry
#

DROP TABLE IF EXISTS `enquiry`;

CREATE TABLE `enquiry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `address` mediumtext NOT NULL,
  `reference` varchar(20) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `note` mediumtext NOT NULL,
  `source` varchar(50) NOT NULL,
  `email` varchar(50) DEFAULT NULL,
  `assigned` varchar(100) NOT NULL,
  `class` int(11) NOT NULL,
  `no_of_child` varchar(11) DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: enquiry_type
#

DROP TABLE IF EXISTS `enquiry_type`;

CREATE TABLE `enquiry_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_type` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` varchar(300) NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `role_id` int(11) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (1, 'check opd patient report', '', '2020-11-30 00:00:00', '2020-11-30 00:00:00', 'task', '#000', '1', 7, 'yes');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (2, 'seminar for medical student', 'na', '2020-11-28 06:30:00', '2020-12-01 06:30:00', 'private', '#c53da9', '1', 0, '');


#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 'Electricity Bill', '', 'yes', 'no', '2020-12-09 06:01:25');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (2, 'Building rent', '', 'yes', 'no', '2020-12-09 06:01:40');


#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `documents` varchar(255) DEFAULT NULL,
  `note` text,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `generated_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `generated_by`) VALUES (1, 1, 'amit', '', '2020-12-09', '200.00', NULL, '', 'yes', 'no', '2020-12-09 06:04:35', 0);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `generated_by`) VALUES (2, 1, 'gggg', '54353', '2020-12-22', '555.00', NULL, 'hhfgh', 'yes', 'no', '2020-12-22 07:55:54', 0);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `generated_by`) VALUES (3, 1, 'test', '2211', '2020-12-22', '500.00', NULL, '', 'yes', 'no', '2020-12-22 09:44:01', 0);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `generated_by`) VALUES (4, 1, 'drrr', '1010', '2021-01-05', '100.00', NULL, '', 'yes', 'no', '2021-01-05 16:43:36', 0);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `generated_by`) VALUES (5, 1, 'aaa', '1010', '2021-01-05', '100.00', NULL, 'gdfsg fdg', 'yes', 'no', '2021-01-06 04:49:08', 0);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `generated_by`) VALUES (6, 1, 'fdsfsd', '1010', '2021-01-05', '10.00', NULL, '', 'yes', 'no', '2021-01-05 16:46:40', 0);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `generated_by`) VALUES (7, 1, 'sing', 'sing', '2021-01-05', '100.00', NULL, '', 'yes', 'no', '2021-01-05 16:47:16', 0);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `generated_by`) VALUES (8, 2, 'rrrr', 'sdfsdfsdf', '2021-01-05', '101.00', NULL, '', 'yes', 'no', '2021-01-05 16:50:53', 0);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `generated_by`) VALUES (9, 1, 'r4441', '441', '2021-01-05', '8252.00', NULL, '', 'yes', 'no', '2021-01-05 16:52:17', 0);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `generated_by`) VALUES (10, 1, 'Name', 'Invoice Number', '2021-01-06', '25550.00', NULL, '', 'yes', 'no', '2021-01-07 10:34:55', 0);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `generated_by`) VALUES (11, 1, 'sdfsdf sdf sdf sdf', ' sdfs s sdf ', '2021-01-06', '100.00', NULL, '', 'yes', 'no', '2021-01-06 04:59:38', 0);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `generated_by`) VALUES (12, 1, 'Name', 'Name', '2021-01-12', '100.00', NULL, '', 'yes', 'no', '2021-01-12 06:40:49', 0);


#
# TABLE STRUCTURE FOR: floor
#

DROP TABLE IF EXISTS `floor`;

CREATE TABLE `floor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `floor` (`id`, `name`, `description`) VALUES (1, 'Ground', '');
INSERT INTO `floor` (`id`, `name`, `description`) VALUES (2, 'First', '');
INSERT INTO `floor` (`id`, `name`, `description`) VALUES (3, 'Second', '');


#
# TABLE STRUCTURE FOR: follow_up
#

DROP TABLE IF EXISTS `follow_up`;

CREATE TABLE `follow_up` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `next_date` date NOT NULL,
  `response` text NOT NULL,
  `note` text NOT NULL,
  `followup_by` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` mediumtext NOT NULL,
  `vid_title` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) NOT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `ext_url` mediumtext,
  `open_new_tab` int(11) DEFAULT '0',
  `ext_url_link` mediumtext,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT '0',
  `description` mediumtext,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (16, 2, 'Home', 1, 0, NULL, NULL, NULL, 'home-1', NULL, 0, NULL, 'no', '2018-07-14 08:44:12');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (23, 1, 'Appointment', 77, 0, '1', NULL, 'https://dev.webfeb.com/sh32/form/appointment', 'appointment', 2, 0, NULL, 'no', '2020-12-19 06:30:22');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (26, 1, 'Home', 1, 0, NULL, NULL, NULL, 'home', NULL, 0, NULL, 'no', '2019-01-24 08:48:17');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (27, 2, 'Appointment', 0, 0, '1', NULL, 'http://yourdomainname.com/form/appointment', 'appointment-1', NULL, 0, NULL, 'no', '2019-11-02 16:24:41');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (28, 1, 'Contact Us', 76, 0, NULL, NULL, NULL, 'contact-us', NULL, 0, NULL, 'no', '2020-12-19 08:15:42');


#
# TABLE STRUCTURE FOR: front_cms_menus
#

DROP TABLE IF EXISTS `front_cms_menus`;

CREATE TABLE `front_cms_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` mediumtext,
  `open_new_tab` int(10) NOT NULL DEFAULT '0',
  `ext_url` mediumtext NOT NULL,
  `ext_url_link` mediumtext NOT NULL,
  `publish` int(11) NOT NULL DEFAULT '0',
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (1, 'Main Menu', 'main-menu', 'Main menu', 0, '', '', 0, 'default', 'no', '2018-04-20 09:24:49');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (2, 'Bottom Menu', 'bottom-menu', 'Bottom Menu', 0, '', '', 0, 'default', 'no', '2018-04-20 09:24:55');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (3, ' vnvn', 'vnvn', '', 0, '', '', 0, 'manual', 'no', '2020-12-29 11:47:32');


#
# TABLE STRUCTURE FOR: front_cms_page_contents
#

DROP TABLE IF EXISTS `front_cms_page_contents`;

CREATE TABLE `front_cms_page_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`),
  CONSTRAINT `front_cms_page_contents_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `front_cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int(1) DEFAULT '0',
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` mediumtext,
  `meta_description` mediumtext,
  `meta_keyword` mediumtext,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext,
  `publish_date` date NOT NULL,
  `publish` int(10) DEFAULT '0',
  `sidebar` int(10) DEFAULT '0',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (1, 'default', 1, 'Home', 'page/home', 'page', 'home', '', '', '', '', '<p>Home page</p>', '0000-00-00', 1, 1, 'no', '2019-01-24 08:33:59');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (2, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<div class=\"col-md-12 col-sm-12\">\r\n<h2 class=\"text-center\">&nbsp;</h2>\r\n\r\n<p class=\"text-center\">[form-builder:complain]</p>\r\n</div>', '0000-00-00', 1, 1, 'no', '2019-01-24 08:30:12');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (54, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<html>\r\n<head>\r\n <title></title>\r\n</head>\r\n<body>\r\n<p>404 page found</p>\r\n</body>\r\n</html>', '0000-00-00', 0, NULL, 'no', '2018-05-18 09:16:04');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (76, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<p>[form-builder:contact_us]</p>', '0000-00-00', 0, NULL, 'no', '2019-01-24 08:31:58');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (77, 'manual', 0, 'our-appointment', 'page/our-appointment', 'page', 'our-appointment', '', '', '', '', '<form action=\"welcome/appointment\" method=\"get\">\r\n  First name: <input type=\"text\" name=\"fname\"><br>\r\n  Last name: <input type=\"text\" name=\"lname\"><br>\r\n  <input type=\"submit\" value=\"Submit\">\r\n</form>', '0000-00-00', 0, 1, 'no', '2019-11-01 07:32:48');


#
# TABLE STRUCTURE FOR: front_cms_program_photos
#

DROP TABLE IF EXISTS `front_cms_program_photos`;

CREATE TABLE `front_cms_program_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `program_id` int(11) DEFAULT NULL,
  `media_gallery_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `program_id` (`program_id`),
  CONSTRAINT `front_cms_program_photos_ibfk_1` FOREIGN KEY (`program_id`) REFERENCES `front_cms_programs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_programs
#

DROP TABLE IF EXISTS `front_cms_programs`;

CREATE TABLE `front_cms_programs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` mediumtext,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` mediumtext,
  `description` mediumtext,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `meta_title` mediumtext NOT NULL,
  `meta_description` mediumtext NOT NULL,
  `meta_keyword` mediumtext NOT NULL,
  `feature_image` mediumtext NOT NULL,
  `publish_date` date NOT NULL,
  `publish` varchar(10) DEFAULT '0',
  `sidebar` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `created_at`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`) VALUES (1, 'notice', 'nmbb', 'read/nmbb', 'nmbb', '2020-12-29', NULL, NULL, NULL, '<p>mm,gjg</p>', 'no', '2020-12-29 12:12:14', '', '', '', '', '0000-00-00', '0', NULL);
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `created_at`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`) VALUES (2, 'notice', 'best-hospital', 'page/', 'Best Hospital', '2020-12-31', NULL, NULL, NULL, '<p>afdsfdc</p>', 'no', '2020-12-31 06:20:22', '', '', '', '', '0000-00-00', '0', NULL);


#
# TABLE STRUCTURE FOR: front_cms_settings
#

DROP TABLE IF EXISTS `front_cms_settings`;

CREATE TABLE `front_cms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int(10) DEFAULT '0',
  `is_active_front_cms` int(11) DEFAULT '0',
  `is_active_sidebar` int(1) DEFAULT '0',
  `logo` varchar(200) DEFAULT NULL,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` mediumtext NOT NULL,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` mediumtext,
  `footer_text` varchar(500) DEFAULT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_settings` (`id`, `theme`, `is_active_rtl`, `is_active_front_cms`, `is_active_sidebar`, `logo`, `contact_us_email`, `complain_form_email`, `sidebar_options`, `fb_url`, `twitter_url`, `youtube_url`, `google_plus`, `instagram_url`, `pinterest_url`, `linkedin_url`, `google_analytics`, `footer_text`, `fav_icon`, `created_at`) VALUES (1, 'yellow', NULL, 1, NULL, '', '', '', '[\"news\",\"complain\"]', '', '', '', '', '', '', '', '', '', './uploads/hospital_content/logo/front_fav_icon-60067a07683f63.63783845.png', '2021-01-19 06:56:45');


#
# TABLE STRUCTURE FOR: general_calls
#

DROP TABLE IF EXISTS `general_calls`;

CREATE TABLE `general_calls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `call_dureation` varchar(50) NOT NULL,
  `note` mediumtext NOT NULL,
  `call_type` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `general_calls` (`id`, `name`, `contact`, `date`, `description`, `follow_up_date`, `call_dureation`, `note`, `call_type`) VALUES (1, 'demo call log', '8498564859', '2021-01-11', 'trdtdtttrdgfdg ', '2021-01-06', '', 'gfdg fdgfd gdfgf fd', 'Incoming');


#
# TABLE STRUCTURE FOR: global_shift
#

DROP TABLE IF EXISTS `global_shift`;

CREATE TABLE `global_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) CHARACTER SET latin1 NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (1, 'Morning', '10:00:00', '13:59:00', '2021-01-13 06:16:26');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (2, 'Noon', '14:00:00', '17:59:00', '2021-01-16 12:15:29');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (9, 'test', '11:15:00', '11:16:00', '2021-01-18 05:54:26');


#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inc_head_id` varchar(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `note` text,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `documents` varchar(255) DEFAULT NULL,
  `generated_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`, `generated_by`) VALUES (1, '1', 'nishu', '36251', '2020-12-09', '500.00', 'gfdgdfgfg', 'yes', 'no', '2020-12-09 11:41:42', NULL, 0);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`, `generated_by`) VALUES (2, '1', 'test', '2133', '2020-12-22', '500.00', 'fgfhgfh', 'yes', 'no', '2020-12-22 07:15:34', NULL, 0);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`, `generated_by`) VALUES (3, '1', 'nishu', '101', '2020-12-29', '500.00', '', 'yes', 'no', '2020-12-29 07:17:08', NULL, 0);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`, `generated_by`) VALUES (4, '1', 'tttttttttt', '321', '2021-01-06', '600.00', 'fgfgdgf', 'yes', 'no', '2021-01-06 08:44:30', NULL, 0);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`, `generated_by`) VALUES (5, '1', 'ddd', '5435', '2021-01-06', '600.00', '', 'yes', 'no', '2021-01-06 09:39:58', NULL, 0);


#
# TABLE STRUCTURE FOR: income_head
#

DROP TABLE IF EXISTS `income_head`;

CREATE TABLE `income_head` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `income_category` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(255) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 'Hospital charges', '', 'yes', 'no', '2020-12-09 06:00:55');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (2, 'Canteen Rent', '', 'yes', 'no', '2020-12-09 06:01:06');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (3, 'bed charges', '', 'yes', 'no', '2020-12-31 09:19:34');


#
# TABLE STRUCTURE FOR: ipd_billing
#

DROP TABLE IF EXISTS `ipd_billing`;

CREATE TABLE `ipd_billing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `discount` int(11) NOT NULL,
  `other_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `tax` decimal(15,2) NOT NULL,
  `gross_total` decimal(15,2) NOT NULL,
  `net_amount` decimal(15,2) NOT NULL,
  `total_amount` decimal(15,2) NOT NULL,
  `generated_by` int(11) NOT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (1, 19, 1, 0, '0', '2020-11-13', '0.00', '600.00', '600.00', '600.00', 3, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (2, 24, 2, 0, '0', '2020-11-16', '0.00', '0.00', '0.00', '0.00', 3, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (3, 4, 3, 0, '0', '2020-11-20', '0.00', '600.00', '500.00', '600.00', 3, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (4, 7, 5, 0, '0', '2020-11-28', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (5, 20, 8, 0, '0.00', '2020-12-03', '0.00', '600.00', '600.00', '600.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (6, 2, 6, 0, '0.00', '2020-12-03', '0.00', '600.00', '500.00', '600.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (7, 26, 9, 0, '0.00', '2020-12-16', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (8, 30, 14, 0, '0.00', '2021-01-14', '0.00', '5000.00', '4800.00', '5000.00', 1, 'paid');


#
# TABLE STRUCTURE FOR: ipd_details
#

DROP TABLE IF EXISTS `ipd_details`;

CREATE TABLE `ipd_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `height` varchar(5) DEFAULT NULL,
  `weight` varchar(5) DEFAULT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `bp` varchar(20) DEFAULT NULL,
  `ipd_no` varchar(200) NOT NULL,
  `room` varchar(100) NOT NULL,
  `bed` varchar(100) NOT NULL,
  `bed_group_id` varchar(10) DEFAULT NULL,
  `case_type` varchar(100) NOT NULL,
  `casualty` varchar(100) NOT NULL,
  `symptoms` varchar(200) NOT NULL,
  `known_allergies` varchar(200) NOT NULL,
  `note` text NOT NULL,
  `refference` varchar(200) NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  `amount` varchar(100) NOT NULL,
  `credit_limit` varchar(100) NOT NULL,
  `tax` varchar(100) NOT NULL,
  `payment_mode` varchar(100) NOT NULL,
  `date` datetime NOT NULL,
  `discharged` varchar(200) NOT NULL,
  `discharged_date` date NOT NULL,
  `live_consult` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (3, 4, '', '', '', '', '', '', 'IPDN3', '', '3', '1', '', 'No', '', '', '', '', 2, '', '20000', '', '', '2020-11-20 10:24:00', 'yes', '2020-11-20', 'Yes');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (4, 4, '', '', '', '', '', '', 'IPDN4', '', '1', '1', '', 'No', '', '', '', '', 2, '', '20000', '', '', '2020-11-21 17:38:00', 'no', '0000-00-00', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (5, 7, '', '', '', '', '', '', 'IPDN5', '', '2', '1', '', 'No', '', '', '', '', 2, '', '20000', '', '', '2020-11-25 13:01:00', 'yes', '2020-11-28', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (6, 2, '', '', '', '', '', '', 'IPDN6', '', '4', '1', '', 'No', '', '', '', '', 2, '', '20000', '', '', '2020-11-26 13:02:00', 'yes', '2020-12-03', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (7, 19, '', '', '', '', '', '', 'IPDN7', '', '2', '1', '', 'No', '', '', '', '', 2, '', '20000', '', '', '2020-11-30 17:44:00', 'no', '2020-12-09', 'Yes');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (8, 20, '', '', '', '', '', '', 'IPDN8', '', '3', '1', '', 'No', '', '', '', '', 2, '', '20000', '', '', '2020-12-03 00:24:00', 'yes', '2020-12-03', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (9, 26, '', '', '', '', '', '', 'IPDN9', '', '3', '1', '', 'No', '', '', '', '', 2, '', '56', '', '', '2020-12-07 15:14:00', 'yes', '2020-12-16', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (10, 35, '', '', '', '', '', '', 'IPDN10', '', '4', '1', '', 'No', '', '', '', '', 4, '', '56', '', '', '2020-12-17 15:08:00', 'no', '0000-00-00', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (11, 1, '', '', '', '', '', '', 'IPDN11', '', '3', '1', '', 'No', '', '', '', '', 2, '', '56', '', '', '2020-12-23 13:11:00', 'no', '0000-00-00', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (12, 37, '', '', '', '', '', '', 'IPDN12', '', '5', '1', '', 'No', '', '', '', '', 2, '', '56', '', '', '2020-12-18 14:39:00', 'no', '0000-00-00', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (13, 40, '', '', '', '', '', '', 'IPDN13', '', '6', '5', '', 'No', '', '', '', '', 2, '', '56', '', '', '2020-11-29 16:13:00', 'no', '0000-00-00', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (14, 30, '', '', '', '', '', '', 'IPDN14', '', '8', '2', '', 'No', '', '', '', '', 2, '', '56', '', '', '2021-01-15 15:51:00', 'yes', '2021-01-14', 'No');


#
# TABLE STRUCTURE FOR: ipd_doctors
#

DROP TABLE IF EXISTS `ipd_doctors`;

CREATE TABLE `ipd_doctors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) NOT NULL,
  `consult_doctor` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (12, 7, 4, '2020-12-29 11:23:21');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (13, 7, 5, '2020-12-29 11:23:21');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (14, 7, 7, '2020-12-29 11:23:21');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (15, 7, 10, '2020-12-29 11:23:21');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (16, 7, 11, '2020-12-29 11:23:21');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (17, 7, 12, '2020-12-29 11:23:21');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (18, 7, 13, '2020-12-29 11:23:21');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (22, 10, 2, '2020-12-30 09:19:29');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (23, 10, 5, '2020-12-30 09:19:29');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (24, 10, 7, '2020-12-30 09:19:29');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (25, 10, 10, '2020-12-30 09:19:29');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (29, 12, 7, '2021-01-14 12:51:19');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (30, 12, 10, '2021-01-14 12:51:19');


#
# TABLE STRUCTURE FOR: ipd_prescription_basic
#

DROP TABLE IF EXISTS `ipd_prescription_basic`;

CREATE TABLE `ipd_prescription_basic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) NOT NULL,
  `header_note` text NOT NULL,
  `footer_note` text NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (1, 6, '<p>dgf</p>', '<p>dfgdfg</p>', '2020-11-27');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (2, 7, '<p>grgfvergvthbtgrfbfg dfdf&nbsp;</p>', '<p>bbbbb fddf d</p>', '2020-11-30');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (3, 12, '<p>hhhhhhhh ffffdddd</p>', '<p>hhhhgggg ffffff</p>', '2021-01-05');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (4, 10, '<p>dddddddd</p>', '<p>sssssss</p>', '2021-01-05');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (5, 7, '<p>aaaaaa</p>', '<p>sssss</p>', '2021-01-05');


#
# TABLE STRUCTURE FOR: ipd_prescription_details
#

DROP TABLE IF EXISTS `ipd_prescription_details`;

CREATE TABLE `ipd_prescription_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `basic_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `medicine_category_id` int(11) NOT NULL,
  `medicine` varchar(200) NOT NULL,
  `dosage` varchar(200) NOT NULL,
  `instruction` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (1, 1, 6, 1, 'Dcold', '1', '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (2, 2, 7, 1, 'Dcold', '1', 'bvnbvhnn');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (3, 3, 12, 1, 'Dcold', '1/2', 'gggg');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (4, 4, 10, 1, 'Dcold', '1', 'ssss');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (5, 4, 10, 1, 'tt', '1', 'ddd');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (6, 5, 7, 1, 'Dcold', '1', 'asas');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (7, 5, 7, 1, 'tt', '1', 'sdasa');


#
# TABLE STRUCTURE FOR: ipd_prescription_test
#

DROP TABLE IF EXISTS `ipd_prescription_test`;

CREATE TABLE `ipd_prescription_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` varchar(100) NOT NULL,
  `pathology_report_id` varchar(100) NOT NULL,
  `radiology_report_id` varchar(100) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_prescription_test` (`id`, `prescription_id`, `pathology_report_id`, `radiology_report_id`, `created_at`) VALUES (1, '3', '1,2', '2,1', '0000-00-00 00:00:00');
INSERT INTO `ipd_prescription_test` (`id`, `prescription_id`, `pathology_report_id`, `radiology_report_id`, `created_at`) VALUES (2, '4', '1', '2,1', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_category_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `unit` varchar(200) NOT NULL,
  `item_photo` varchar(225) DEFAULT NULL,
  `description` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `item_store_id` int(11) DEFAULT NULL,
  `item_supplier_id` int(11) DEFAULT NULL,
  `quantity` int(100) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `created_at`, `item_store_id`, `item_supplier_id`, `quantity`, `date`) VALUES (2, 1, 'fsdf', '50', NULL, '', '2021-01-09 11:44:38', NULL, NULL, 0, '0000-00-00');
INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `created_at`, `item_store_id`, `item_supplier_id`, `quantity`, `date`) VALUES (3, 1, 'Medicine', '5', NULL, '', '2020-12-29 11:25:30', NULL, NULL, 0, '0000-00-00');


#
# TABLE STRUCTURE FOR: item_category
#

DROP TABLE IF EXISTS `item_category`;

CREATE TABLE `item_category` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_category` varchar(255) NOT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `description` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (1, 'Syringe', 'yes', '', '2020-11-16 12:22:51');


#
# TABLE STRUCTURE FOR: item_issue
#

DROP TABLE IF EXISTS `item_issue`;

CREATE TABLE `item_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_type` varchar(15) DEFAULT NULL,
  `issue_to` varchar(100) DEFAULT NULL,
  `issue_by` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `quantity` int(10) NOT NULL,
  `note` text NOT NULL,
  `is_returned` int(2) NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `is_active` varchar(10) DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_category_id` (`item_category_id`),
  CONSTRAINT `item_issue_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_2` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (4, '3', '4', 'Super Admin', '2021-01-07', '0000-00-00', 1, 3, 1, 'wwww', 1, '2021-01-09 12:48:15', 'no');


#
# TABLE STRUCTURE FOR: item_stock
#

DROP TABLE IF EXISTS `item_stock`;

CREATE TABLE `item_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `symbol` varchar(10) NOT NULL DEFAULT '+',
  `store_id` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `purchase_price` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  `description` text NOT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `item_stock_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (3, 2, 1, '+', 1, 10, '10', '2020-11-20', NULL, '', 'yes', '2020-11-20 06:03:12');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (4, 3, 1, '+', 1, 10, '1000', '2020-12-29', NULL, '', 'yes', '2020-12-29 11:26:34');


#
# TABLE STRUCTURE FOR: item_store
#

DROP TABLE IF EXISTS `item_store`;

CREATE TABLE `item_store` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_store` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`) VALUES (1, 'SK pharma', 'ss123', '');


#
# TABLE STRUCTURE FOR: item_supplier
#

DROP TABLE IF EXISTS `item_supplier`;

CREATE TABLE `item_supplier` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_supplier` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `contact_person_name` varchar(255) NOT NULL,
  `contact_person_phone` varchar(255) NOT NULL,
  `contact_person_email` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`) VALUES (1, 'john', '8958659864', 'jhon@gmail.com', 'jbp', '6589586954', '9856985698', 'ajay@gmail.com', 'test');


#
# TABLE STRUCTURE FOR: lab
#

DROP TABLE IF EXISTS `lab`;

CREATE TABLE `lab` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lab_name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `lab` (`id`, `lab_name`) VALUES (1, 'xray');
INSERT INTO `lab` (`id`, `lab_name`) VALUES (2, 'sonography');


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `short_code` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8;

INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'az', 'az', 'no', 'no', '2019-11-20 11:23:12', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'sq', 'al', 'no', 'no', '2019-11-20 11:42:42', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'am', 'am', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'en', 'us', 'no', 'no', '2019-11-20 11:38:50', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'ar', 'sa', 'no', 'no', '2019-11-20 11:47:28', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Afrikaans', 'af', 'af', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Basque', 'eu', 'es', 'no', 'no', '2019-11-20 11:54:10', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Bengali', 'bn', 'in', 'no', 'no', '2019-11-20 11:41:53', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Bosnian', 'bs', 'bs', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Welsh', 'cy', 'cy', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Hungarian', 'hu', 'hu', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Vietnamese', 'vi', 'vi', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Haitian', 'ht', 'ht', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Galician', 'gl', 'gl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Dutch', 'nl', 'nl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Greek', 'el', 'gr', 'no', 'no', '2019-11-20 12:12:08', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Georgian', 'ka', 'ge', 'no', 'no', '2019-11-20 12:11:40', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Gujarati', 'gu', 'in', 'no', 'no', '2019-11-20 11:39:16', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Danish', 'da', 'dk', 'no', 'no', '2019-11-20 12:03:25', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Hebrew', 'he', 'il', 'no', 'no', '2019-11-20 12:13:50', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Yiddish', 'yi', 'il', 'no', 'no', '2019-11-20 12:25:33', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Indonesian', 'id', 'id', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Irish', 'ga', 'ga', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Italian', 'it', 'it', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Icelandic', 'is', 'is', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Spanish', 'es', 'es', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Kannada', 'kn', 'kn', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Catalan', 'ca', 'ca', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Chinese', 'zh', 'cn', 'no', 'no', '2019-11-20 12:01:48', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Korean', 'ko', 'kr', 'no', 'no', '2019-11-20 12:19:09', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Xhosa', 'xh', 'ls', 'no', 'no', '2019-11-20 12:24:39', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Latin', 'la', 'la', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Latvian', 'lv', 'lv', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Lithuanian', 'lt', 'lt', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'Malagasy', 'mg', 'mg', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Malay', 'ms', 'ms', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Malayalam', 'ml', 'ml', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Maltese', 'mt', 'mt', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Macedonian', 'mk', 'mk', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Maori', 'mi', 'nz', 'no', 'no', '2019-11-20 12:20:27', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Marathi', 'mr', 'in', 'no', 'no', '2019-11-20 11:39:51', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Mongolian', 'mn', 'mn', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'German', 'de', 'de', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Nepali', 'ne', 'ne', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Norwegian', 'no', 'no', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Punjabi', 'pa', 'in', 'no', 'no', '2019-11-20 11:40:16', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Persian', 'fa', 'ir', 'no', 'no', '2019-11-20 12:21:17', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Portuguese', 'pt', 'pt', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Romanian', 'ro', 'ro', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Russian', 'ru', 'ru', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Cebuano', 'ceb', 'ph', 'no', 'no', '2019-11-20 11:59:12', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Sinhala', 'si', 'si', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'Slovakian', 'sk', 'sk', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Slovenian', 'sl', 'sl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Swahili', 'sw', 'ke', 'no', 'no', '2019-11-20 12:21:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Sundanese', 'su', 'sd', 'no', 'no', '2019-12-03 11:06:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Thai', 'th', 'th', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Tagalog', 'tl', 'tl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Tamil', 'ta', 'in', 'no', 'no', '2019-11-20 11:40:53', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Telugu', 'te', 'in', 'no', 'no', '2019-11-20 11:41:15', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Turkish', 'tr', 'tr', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Uzbek', 'uz', 'uz', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'Urdu', 'ur', 'pk', 'no', 'no', '2019-11-20 12:23:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'Finnish', 'fi', 'fi', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'French', 'fr', 'fr', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'Hindi', 'hi', 'in', 'no', 'no', '2019-11-20 11:36:34', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'Czech', 'cs', 'cz', 'no', 'no', '2019-11-20 12:02:36', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'Swedish', 'sv', 'sv', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'Scottish', 'gd', 'gd', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'Estonian', 'et', 'et', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'Esperanto', 'eo', 'br', 'no', 'no', '2019-11-21 04:49:18', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'Javanese', 'jv', 'id', 'no', 'no', '2019-11-20 12:18:29', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'Japanese', 'ja', 'jp', 'no', 'no', '2019-11-20 12:14:39', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'Polish', 'pl', 'pl', 'yes', 'no', '2020-04-05 14:09:04', NULL);


#
# TABLE STRUCTURE FOR: leave_types
#

DROP TABLE IF EXISTS `leave_types`;

CREATE TABLE `leave_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `leave_types` (`id`, `type`, `is_active`) VALUES (1, 'Man nahi hai', 'yes');
INSERT INTO `leave_types` (`id`, `type`, `is_active`) VALUES (2, 'Physician', 'yes');
INSERT INTO `leave_types` (`id`, `type`, `is_active`) VALUES (3, 'Heart Specialist', 'yes');
INSERT INTO `leave_types` (`id`, `type`, `is_active`) VALUES (4, 'Diabetes Specialist', 'yes');
INSERT INTO `leave_types` (`id`, `type`, `is_active`) VALUES (5, 'medical leave', 'yes');


#
# TABLE STRUCTURE FOR: medicine_bad_stock
#

DROP TABLE IF EXISTS `medicine_bad_stock`;

CREATE TABLE `medicine_bad_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pharmacy_id` int(11) NOT NULL,
  `outward_date` date NOT NULL,
  `expiry_date` varchar(200) NOT NULL,
  `batch_no` varchar(200) NOT NULL,
  `quantity` varchar(200) NOT NULL,
  `note` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `medicine_bad_stock` (`id`, `pharmacy_id`, `outward_date`, `expiry_date`, `batch_no`, `quantity`, `note`) VALUES (1, 1, '2020-12-14', '12-31-2021', '11', '10', '');


#
# TABLE STRUCTURE FOR: medicine_batch_details
#

DROP TABLE IF EXISTS `medicine_batch_details`;

CREATE TABLE `medicine_batch_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_bill_basic_id` varchar(100) NOT NULL,
  `medicine_category_id` varchar(200) NOT NULL,
  `pharmacy_id` int(100) NOT NULL,
  `inward_date` datetime NOT NULL,
  `expiry_date` varchar(100) DEFAULT NULL,
  `expiry_date_format` date NOT NULL,
  `batch_no` varchar(100) NOT NULL,
  `packing_qty` varchar(100) NOT NULL,
  `purchase_rate_packing` varchar(100) NOT NULL,
  `quantity` varchar(200) NOT NULL,
  `mrp` varchar(11) DEFAULT NULL,
  `purchase_price` varchar(200) NOT NULL,
  `sale_rate` varchar(11) DEFAULT NULL,
  `batch_amount` decimal(10,2) NOT NULL,
  `amount` varchar(100) DEFAULT NULL,
  `available_quantity` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (1, '1', '1', 1, '2020-11-14 14:15:00', 'Feb/2019', '2019-02-01', '2489', '20', '', '10', '200', '100', '180', '2000.00', '1000', '0', '2020-11-13 08:46:52');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (2, '2', '1', 1, '2020-11-16 15:24:00', 'Mar/2022', '2022-03-01', '3251', '20', '', '20', '200', '80', '150', '1000.00', '1600', '0', '2020-11-16 09:55:55');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (3, '3', '1', 1, '2020-11-30 16:47:00', 'Jun/2020', '2020-06-01', '2315', '', '', '10', '230', '150', '600', '0.00', '1500', '3', '2020-11-30 11:18:53');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (4, '4', '1', 1, '2020-11-30 16:49:00', 'Feb/2020', '2020-03-01', '32313', '', '', '10', '200', '140', '500', '0.00', '1400', '0', '2020-11-30 11:19:42');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (5, '5', '1', 1, '2020-11-30 17:07:00', 'May/2020', '2020-05-01', '11', '1', '', '1', '1', '10', '1', '1.00', '10', '1', '2020-11-30 11:42:03');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (6, '6', '1', 1, '2020-12-05 17:49:00', 'Feb/2020', '2020-02-01', '432', '12', '', '12', '1111', '800', '222', '222.00', '9600', '12', '2020-12-05 12:19:15');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (7, '7', '1', 1, '2020-12-14 11:00:00', 'Dec/2021', '2021-12-01', '3251', '10', '', '10', '150', '80', '100', '500.00', '800', '10', '2020-12-14 05:32:27');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (8, '8', '1', 3, '2020-12-16 20:12:00', 'Jul/2020', '2020-07-01', '10100', '10', '', '100', '10', '10', '15', '10101.00', '1000', '100', '2020-12-14 14:42:26');


#
# TABLE STRUCTURE FOR: medicine_category
#

DROP TABLE IF EXISTS `medicine_category`;

CREATE TABLE `medicine_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_category` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `medicine_category` (`id`, `medicine_category`) VALUES (1, 'Tablet');
INSERT INTO `medicine_category` (`id`, `medicine_category`) VALUES (2, 'Syrup');
INSERT INTO `medicine_category` (`id`, `medicine_category`) VALUES (3, 'Capsules');


#
# TABLE STRUCTURE FOR: medicine_dosage
#

DROP TABLE IF EXISTS `medicine_dosage`;

CREATE TABLE `medicine_dosage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_category_id` int(11) NOT NULL,
  `dosage_form` varchar(100) NOT NULL,
  `dosage` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (1, 1, '', '1');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (2, 1, '', '1/2');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (3, 2, '', '10 ml');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (4, 2, '', '5 ml');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (5, 3, '', '1');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (6, 1, '', '1');


#
# TABLE STRUCTURE FOR: messages
#

DROP TABLE IF EXISTS `messages`;

CREATE TABLE `messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) DEFAULT NULL,
  `message` text,
  `send_mail` varchar(10) DEFAULT '0',
  `send_sms` varchar(10) DEFAULT '0',
  `is_group` varchar(10) DEFAULT '0',
  `is_individual` varchar(10) DEFAULT '0',
  `file` varchar(200) NOT NULL,
  `group_list` text,
  `user_list` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `messages` (`id`, `title`, `message`, `send_mail`, `send_sms`, `is_group`, `is_individual`, `file`, `group_list`, `user_list`, `created_at`) VALUES (1, 'hghgfhfg', 'fhfghfgh', '0', '1', '1', '0', '', '[]', NULL, '2020-12-02 10:28:48');
INSERT INTO `messages` (`id`, `title`, `message`, `send_mail`, `send_sms`, `is_group`, `is_individual`, `file`, `group_list`, `user_list`, `created_at`) VALUES (2, 'sagar', '<p>sagar</p>\r\n', '1', '0', '0', '1', '', NULL, '[{\"category\":\"patient\",\"user_id\":\"50\",\"email\":\"sagar.shrivastava889@gmail.com\",\"mobileno\":\"9999999999\",\"app_key\":\"\"}]', '2021-01-16 05:26:33');
INSERT INTO `messages` (`id`, `title`, `message`, `send_mail`, `send_sms`, `is_group`, `is_individual`, `file`, `group_list`, `user_list`, `created_at`) VALUES (3, 'ttest', '<p>test</p>\r\n', '1', '0', '0', '1', '', NULL, '[{\"category\":\"patient\",\"user_id\":\"50\",\"email\":\"sagar.shrivastava889@gmail.com\",\"mobileno\":\"9999999999\",\"app_key\":\"\"}]', '2021-01-19 05:19:32');
INSERT INTO `messages` (`id`, `title`, `message`, `send_mail`, `send_sms`, `is_group`, `is_individual`, `file`, `group_list`, `user_list`, `created_at`) VALUES (4, 'test', '<p>test</p>\r\n', '1', '0', '0', '1', '', NULL, '[{\"category\":\"patient\",\"user_id\":\"53\",\"email\":\"sagar.shrivastav889@gmail.com\",\"mobileno\":\"09926226695\",\"app_key\":\"\"}]', '2021-01-19 05:43:06');
INSERT INTO `messages` (`id`, `title`, `message`, `send_mail`, `send_sms`, `is_group`, `is_individual`, `file`, `group_list`, `user_list`, `created_at`) VALUES (5, 'test', '<p>test</p>\r\n', '1', '0', '0', '1', '', NULL, '[{\"category\":\"patient\",\"user_id\":\"53\",\"email\":\"sagar.shrivastav889@gmail.com\",\"mobileno\":\"09926226695\",\"app_key\":\"\"}]', '2021-01-19 05:50:25');
INSERT INTO `messages` (`id`, `title`, `message`, `send_mail`, `send_sms`, `is_group`, `is_individual`, `file`, `group_list`, `user_list`, `created_at`) VALUES (6, 'test', '<p>etstest</p>\r\n', '1', '0', '0', '1', '', NULL, '[{\"category\":\"patient\",\"user_id\":\"3\",\"email\":\"nitin.koshta1990@gmail.com\",\"mobileno\":\"\",\"app_key\":\"\"}]', '2021-01-19 05:56:05');


#
# TABLE STRUCTURE FOR: migrations
#

DROP TABLE IF EXISTS `migrations`;

CREATE TABLE `migrations` (
  `version` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: notification_roles
#

DROP TABLE IF EXISTS `notification_roles`;

CREATE TABLE `notification_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `send_notification_id` int(11) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `send_notification_id` (`send_notification_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `notification_roles_ibfk_1` FOREIGN KEY (`send_notification_id`) REFERENCES `send_notification` (`id`) ON DELETE CASCADE,
  CONSTRAINT `notification_roles_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `notification_roles` (`id`, `send_notification_id`, `role_id`, `is_active`, `created_at`) VALUES (1, 1, 1, 0, '2020-12-05 11:33:02');
INSERT INTO `notification_roles` (`id`, `send_notification_id`, `role_id`, `is_active`, `created_at`) VALUES (2, 1, 2, 0, '2020-12-05 11:33:02');
INSERT INTO `notification_roles` (`id`, `send_notification_id`, `role_id`, `is_active`, `created_at`) VALUES (3, 1, 3, 0, '2020-12-05 11:33:02');
INSERT INTO `notification_roles` (`id`, `send_notification_id`, `role_id`, `is_active`, `created_at`) VALUES (4, 1, 4, 0, '2020-12-05 11:33:02');
INSERT INTO `notification_roles` (`id`, `send_notification_id`, `role_id`, `is_active`, `created_at`) VALUES (5, 2, 3, 0, '2020-12-05 11:33:39');
INSERT INTO `notification_roles` (`id`, `send_notification_id`, `role_id`, `is_active`, `created_at`) VALUES (6, 3, 3, 0, '2020-12-29 10:20:56');


#
# TABLE STRUCTURE FOR: notification_setting
#

DROP TABLE IF EXISTS `notification_setting`;

CREATE TABLE `notification_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT NULL,
  `is_mail` int(11) DEFAULT '0',
  `is_sms` int(11) DEFAULT '0',
  `is_mobileapp` int(11) NOT NULL,
  `is_notification` int(11) NOT NULL,
  `display_notification` int(11) NOT NULL,
  `display_sms` int(11) NOT NULL,
  `template` longtext NOT NULL,
  `subject` text NOT NULL,
  `variables` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (1, 'opd_patient_registration', 1, 0, 0, 0, 1, 1, 'Dear {{patient_name}} your OPD Registration is successful at Hospital Name with Patient Id {{patient_unique_id}} and OPD No  {{opd_no}}', 'OPD Patient', '{{patient_name}} {{mobileno}} {{email}}  {{dob}} {{gender}}  {{patient_unique_id}}    {{opd_no}}', '2021-01-19 05:04:35');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (2, 'ipd_patient_registration', 1, 0, 0, 0, 1, 1, 'Dear {{patient_name}} your IPD Registration is successful at Hospital Name with Patient Id  {{patient_unique_id}} and IPD No {{ipd_no}}', 'IPD Patient', '{{patient_name}} {{mobileno}} {{email}}  {{dob}} {{gender}}  {{patient_unique_id}}   {{ipd_no}} ', '2020-11-10 06:59:59');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (3, 'ipd_patient_discharged', 1, 0, 0, 0, 1, 1, 'IPD Patient {{patient_name}} is now discharged from Hospital Name Total Charges: {{currency_symbol}} {{charge_amount}}  Total payment: {{currency_symbol}} {{paid_amount}} Your net payable bill amount was {{currency_symbol}} {{net_amount}}', 'IPD Discharged Patient', '{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{currency_symbol}} {{charge_amount}} {{paid_amount}} {{net_amount}}', '2020-11-10 06:59:59');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (4, 'opd_patient_revisit', 1, 0, 0, 0, 1, 1, 'Dear {{patient_name}} your OPD Registration is successful at Hospital Name with Patient Id  {{patient_unique_id}} and OPD No {{opd_no}}\r\n\r\n{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{opd_no}}', 'OPD Patient Revisit', '{{patient_name}} {{mobileno}} {{email}}  {{dob}} {{gender}}  {{patient_unique_id}} {{opd_no}} ', '2020-11-10 06:59:59');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (5, 'login_credential', 1, 0, 0, 0, 0, 1, 'Hello {{display_name}} your login details for Url: {{url}} Username:  {{username}} Password: {{password}} {{email}}', 'Login Patient', '{{display_name}}    {{url}} {{username}} {{password}} {{email}}', '2020-11-10 06:57:09');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (6, 'appointment_approved', 1, 0, 0, 0, 1, 1, 'Dear {{patient_name}} your appointment with {{staff_name}} {{staff_surname}} is confirmed on {{date}} with appointment no: {{appointment_no}}', 'Appointment Approved', '{{patient_name}} {{mobileno}} {{email}}   {{gender}}    {{staff_name}}\r\n{{staff_surname}}  {{date}} {{appointment_no}}', '2020-11-10 06:59:59');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (7, 'live_meeting', 1, 0, 0, 0, 0, 1, 'Dear staff, your live meeting {{title}} has been scheduled on {{date}} for the duration of {{duration}} minute, please do not share the link to any body.\r\n\r\n{{title}} {{date}} {{duration}} {{employee_id}} {{department}} {{designation}} {{name}} {{contact_no}} {{email}}', 'Live Meeting', '{{title}} {{date}} {{duration}} {{employee_id}} {{department}} {{designation}} {{name}} {{contact_no}} {{email}}', '2020-11-07 12:55:38');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (8, 'live_consult', 1, 0, 0, 0, 1, 1, 'Dear patient, your live consultation {{title}} has been scheduled on {{date}} for the duration of {{duration}} minute, please do not share the link to any body.\r\n\r\n{{title}} {{date}} {{duration}}', 'Live Consultation', '{{title}} {{date}} {{duration}}', '2020-11-10 06:59:59');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (9, 'opd_patient_discharged', 1, 0, 0, 0, 1, 1, 'OPD No {{opd_no}}  {{patient_name}} is now discharged from Hospital Name Your net payable bill amount was {{currency_symbol}}  \r\n {{billing_amount}}\r\n\r\n\r\n{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{opd_no}} {{currency_symbol}} {{billing_amount}}', 'OPD Discharged Patient', '{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{opd_no}}{{currency_symbol}} {{billing_amount}}', '2020-11-10 06:59:59');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (10, 'forgot_password', 1, 0, 0, 0, 0, 0, 'Dear  {{display_name}} , Recently a request was submitted to reset password for your account. If you didn\'t make the request, just ignore this email. Otherwise you can reset your password using this link <a href=\'{{resetpasslink}}\'>Click here to reset your password</a>, if you\'re having trouble clicking the password reset button, copy and paste the URL below into your web browser. {{resetpasslink}} <br> Regards,  <br>\r\nHospital Name', 'Password Update Request', '{{display_name}}  {{email}}  {{resetpasslink}', '2020-12-04 07:59:56');


#
# TABLE STRUCTURE FOR: nurse_note
#

DROP TABLE IF EXISTS `nurse_note`;

CREATE TABLE `nurse_note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `nurse` int(11) NOT NULL,
  `note` text NOT NULL,
  `comment` text NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

INSERT INTO `nurse_note` (`id`, `date`, `patient_id`, `ipd_id`, `nurse`, `note`, `comment`, `updated_at`) VALUES (14, '2020-12-29 12:34:00', 37, 12, 8, 'nnnnnnn', 'ccccccccc', '2020-12-29 12:34:00');
INSERT INTO `nurse_note` (`id`, `date`, `patient_id`, `ipd_id`, `nurse`, `note`, `comment`, `updated_at`) VALUES (15, '2021-01-06 17:41:00', 19, 7, 8, 'Best Facility', 'best medicine', '2021-01-06 17:41:00');
INSERT INTO `nurse_note` (`id`, `date`, `patient_id`, `ipd_id`, `nurse`, `note`, `comment`, `updated_at`) VALUES (16, '2021-01-06 17:55:00', 35, 10, 8, 'Patient medicine timing', 'Best Medicine', '2021-01-06 17:55:00');
INSERT INTO `nurse_note` (`id`, `date`, `patient_id`, `ipd_id`, `nurse`, `note`, `comment`, `updated_at`) VALUES (17, '2021-01-11 11:04:00', 37, 12, 8, 'This is a testing nurse note', 'test', '2021-01-11 11:04:00');
INSERT INTO `nurse_note` (`id`, `date`, `patient_id`, `ipd_id`, `nurse`, `note`, `comment`, `updated_at`) VALUES (18, '2021-01-11 11:06:00', 37, 12, 8, '[removed][removed]', '[removed][removed]', '2021-01-11 11:06:00');


#
# TABLE STRUCTURE FOR: nurse_notes_comment
#

DROP TABLE IF EXISTS `nurse_notes_comment`;

CREATE TABLE `nurse_notes_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nurse_note_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `comment_staff` text CHARACTER SET latin1 NOT NULL,
  `comment_staffid` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `nurse_notes_comment` (`id`, `nurse_note_id`, `ipd_id`, `comment_staff`, `comment_staffid`, `created_at`) VALUES (2, 6, 7, 'Comment  2', 1, '2020-12-28 05:30:42');
INSERT INTO `nurse_notes_comment` (`id`, `nurse_note_id`, `ipd_id`, `comment_staff`, `comment_staffid`, `created_at`) VALUES (3, 5, 7, 'Comment 100', 1, '2020-12-28 05:30:56');
INSERT INTO `nurse_notes_comment` (`id`, `nurse_note_id`, `ipd_id`, `comment_staff`, `comment_staffid`, `created_at`) VALUES (4, 6, 7, 'commit 200', 1, '2020-12-28 05:31:05');
INSERT INTO `nurse_notes_comment` (`id`, `nurse_note_id`, `ipd_id`, `comment_staff`, `comment_staffid`, `created_at`) VALUES (5, 1, 10, 'comment1', 1, '2020-12-28 05:40:33');
INSERT INTO `nurse_notes_comment` (`id`, `nurse_note_id`, `ipd_id`, `comment_staff`, `comment_staffid`, `created_at`) VALUES (6, 5, 7, 'comment 11', 1, '2020-12-28 06:11:46');
INSERT INTO `nurse_notes_comment` (`id`, `nurse_note_id`, `ipd_id`, `comment_staff`, `comment_staffid`, `created_at`) VALUES (7, 8, 7, 'ddddddddddssssssaaaaaa', 1, '2020-12-28 06:28:14');
INSERT INTO `nurse_notes_comment` (`id`, `nurse_note_id`, `ipd_id`, `comment_staff`, `comment_staffid`, `created_at`) VALUES (9, 4, 10, 'ttttttttttttt', 1, '2020-12-29 10:55:52');
INSERT INTO `nurse_notes_comment` (`id`, `nurse_note_id`, `ipd_id`, `comment_staff`, `comment_staffid`, `created_at`) VALUES (10, 18, 12, 'hello', 1, '2021-01-19 11:07:57');


#
# TABLE STRUCTURE FOR: opd_billing
#

DROP TABLE IF EXISTS `opd_billing`;

CREATE TABLE `opd_billing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `opd_id` int(11) NOT NULL,
  `discount` int(11) NOT NULL,
  `other_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `tax` decimal(15,2) NOT NULL,
  `gross_total` decimal(15,2) NOT NULL,
  `net_amount` decimal(15,2) NOT NULL,
  `total_amount` decimal(15,2) NOT NULL,
  `generated_by` int(11) NOT NULL,
  `status` varchar(100) NOT NULL,
  `paymode` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (1, 27, 1, 0, '0', '2020-11-16', '0.00', '600.00', '600.00', '600.00', 3, 'paid', '');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (2, 1, 3, 0, '0', '2020-11-16', '0.00', '700.00', '700.00', '700.00', 3, 'paid', '');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (3, 2, 7, 0, '0', '2020-11-27', '0.00', '0.00', '0.00', '0.00', 1, 'paid', '');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (4, 7, 9, 0, '0', '2020-11-27', '0.00', '0.00', '0.00', '0.00', 1, 'paid', '');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (5, 4, 6, 0, '0', '2020-11-28', '0.00', '0.00', '0.00', '0.00', 1, 'paid', '');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (6, 2, 4, 0, '0', '2020-11-28', '0.00', '1000.00', '1000.00', '1000.00', 1, 'paid', 'Cash');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (7, 1, 10, 0, '0', '2020-11-28', '0.00', '0.00', '0.00', '0.00', 1, 'paid', 'Cheque');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (8, 8, 12, 0, '0', '2020-11-28', '0.00', '0.00', '0.00', '0.00', 1, 'paid', 'Cash');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (9, 11, 14, 0, '0.00', '2020-11-28', '0.00', '0.00', '0.00', '0.00', 1, 'paid', 'Cash');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (10, 7, 11, 0, '0.00', '2020-11-28', '0.00', '600.00', '600.00', '600.00', 1, 'paid', 'Cash');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (11, 17, 19, 0, '0.00', '2020-11-30', '0.00', '600.00', '600.00', '600.00', 1, 'paid', 'Cash');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (12, 18, 20, 0, '0.00', '2020-11-30', '0.00', '600.00', '600.00', '600.00', 1, 'paid', 'Cash');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (13, 16, 18, 60, '0.00', '2020-12-01', '27.00', '567.00', '567.00', '600.00', 1, 'paid', 'Online');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (14, 11, 15, 0, '10000.00', '2020-12-01', '0.00', '10000.00', '10000.00', '0.00', 1, 'paid', 'Cash');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (15, 10, 13, 100, '1000.00', '2020-12-01', '0.00', '900.00', '900.00', '0.00', 1, 'paid', 'Cash');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (16, 19, 24, 0, '0.00', '2020-12-05', '0.00', '1800.00', '1799.00', '1800.00', 1, 'paid', 'Cash');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (17, 31, 30, 0, '0.00', '2020-12-14', '0.00', '0.00', '0.00', '0.00', 1, 'paid', 'Cheque');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (18, 36, 33, 0, '0.00', '2020-12-15', '0.00', '605.00', '405.00', '605.00', 1, 'paid', 'Cash');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`, `paymode`) VALUES (19, 43, 16909, 0, '0.00', '2021-01-19', '0.00', '0.00', '0.00', '0.00', 1, 'paid', 'Cash');


#
# TABLE STRUCTURE FOR: opd_details
#

DROP TABLE IF EXISTS `opd_details`;

CREATE TABLE `opd_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `opd_no` varchar(100) NOT NULL,
  `appointment_date` datetime NOT NULL,
  `case_type` varchar(200) NOT NULL,
  `casualty` varchar(200) NOT NULL,
  `symptoms` text,
  `bp` varchar(200) NOT NULL,
  `height` varchar(100) NOT NULL,
  `weight` varchar(100) NOT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `known_allergies` varchar(200) NOT NULL,
  `note_remark` varchar(225) DEFAULT NULL,
  `refference` varchar(100) NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `tax` decimal(15,2) NOT NULL,
  `payment_mode` varchar(200) NOT NULL,
  `header_note` text NOT NULL,
  `footer_note` text NOT NULL,
  `generated_by` int(11) NOT NULL,
  `discharged` varchar(200) NOT NULL,
  `live_consult` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16913 DEFAULT CHARSET=utf8;

INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (3, 1, 'OPDN3', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'yes', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (4, 2, 'OPDN4', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>aaaaaaaaaa</p>', '<p>aaaaaaaaa</p>', 1, 'yes', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (5, 4, 'OPDN5', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (6, 4, 'OPDN6', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'yes', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (7, 2, 'OPDN7', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'yes', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (8, 1, 'OPDN8', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (9, 7, 'OPDN9', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'yes', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (10, 1, 'OPDN10', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'yes', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (11, 7, 'OPDN11', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'yes', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (12, 8, 'OPDN12', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'yes', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (13, 10, 'OPDN13', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'yes', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (14, 11, 'OPDN14', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'yes', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (15, 11, 'OPDN15', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'yes', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (16, 16, 'OPDN16', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (17, 16, 'OPDN17', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (18, 16, 'OPDN18', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'yes', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (19, 17, 'OPDN19', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'yes', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (20, 18, 'OPDN20', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'yes', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (21, 18, 'OPDN21', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (22, 20, 'OPDN22', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (23, 21, 'OPDN23', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (24, 19, 'OPDN24', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'yes', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (25, 17, 'OPDN25', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (26, 17, 'OPDN26', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (27, 1, 'OPDN27', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (28, 30, 'OPDN28', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (29, 30, 'OPDN29', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (30, 31, 'OPDN30', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'yes', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (31, 17, 'OPDN31', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (32, 32, 'OPDN32', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (33, 36, 'OPDN33', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'yes', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (34, 37, 'OPDN34', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (35, 36, 'OPDN35', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (36, 1, 'OPDN36', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (37, 2, 'OPDN37', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (38, 4, 'OPDN38', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (39, 4, 'OPDN39', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (40, 2, 'OPDN40', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (41, 1, 'OPDN41', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (42, 7, 'OPDN42', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (43, 1, 'OPDN43', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (44, 7, 'OPDN44', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (45, 8, 'OPDN45', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (46, 10, 'OPDN46', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (47, 11, 'OPDN47', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (48, 11, 'OPDN48', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (49, 16, 'OPDN49', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (50, 16, 'OPDN50', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (51, 16, 'OPDN51', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (52, 17, 'OPDN52', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (53, 18, 'OPDN53', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (54, 18, 'OPDN54', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (55, 20, 'OPDN55', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (56, 21, 'OPDN56', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (57, 19, 'OPDN57', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (58, 17, 'OPDN58', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (59, 17, 'OPDN59', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (60, 1, 'OPDN60', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (61, 30, 'OPDN61', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (62, 30, 'OPDN62', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (63, 31, 'OPDN63', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (64, 17, 'OPDN64', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (65, 32, 'OPDN65', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (66, 36, 'OPDN66', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (67, 37, 'OPDN67', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (68, 36, 'OPDN68', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (69, 1, 'OPDN66', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (70, 2, 'OPDN66', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (71, 4, 'OPDN66', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (72, 4, 'OPDN66', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (73, 2, 'OPDN66', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (74, 1, 'OPDN66', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (75, 7, 'OPDN66', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (76, 1, 'OPDN66', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (77, 7, 'OPDN66', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (78, 8, 'OPDN66', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (79, 10, 'OPDN66', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (80, 11, 'OPDN66', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (81, 11, 'OPDN66', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (82, 16, 'OPDN66', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (83, 16, 'OPDN66', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (84, 16, 'OPDN66', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (85, 17, 'OPDN66', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (86, 18, 'OPDN66', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (87, 18, 'OPDN66', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (88, 20, 'OPDN66', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (89, 21, 'OPDN66', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (90, 19, 'OPDN66', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (91, 17, 'OPDN66', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (92, 17, 'OPDN66', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (93, 1, 'OPDN66', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (94, 30, 'OPDN66', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (95, 30, 'OPDN66', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (96, 31, 'OPDN66', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (97, 17, 'OPDN66', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (98, 32, 'OPDN66', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (99, 36, 'OPDN66', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (100, 37, 'OPDN66', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (101, 36, 'OPDN66', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (102, 1, 'OPDN66', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (103, 2, 'OPDN66', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (104, 4, 'OPDN66', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (105, 4, 'OPDN66', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (106, 2, 'OPDN66', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (107, 1, 'OPDN66', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (108, 7, 'OPDN66', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (109, 1, 'OPDN66', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (110, 7, 'OPDN66', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (111, 8, 'OPDN66', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (112, 10, 'OPDN66', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (113, 11, 'OPDN66', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (114, 11, 'OPDN66', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (115, 16, 'OPDN66', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (116, 16, 'OPDN66', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (117, 16, 'OPDN66', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (118, 17, 'OPDN66', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (119, 18, 'OPDN66', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (120, 18, 'OPDN66', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (121, 20, 'OPDN66', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (122, 21, 'OPDN66', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (123, 19, 'OPDN66', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (124, 17, 'OPDN66', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (125, 17, 'OPDN66', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (126, 1, 'OPDN66', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (127, 30, 'OPDN66', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (128, 30, 'OPDN66', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (129, 31, 'OPDN66', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (130, 17, 'OPDN66', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (131, 32, 'OPDN66', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (132, 36, 'OPDN66', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (133, 37, 'OPDN66', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (134, 36, 'OPDN66', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (135, 1, 'OPDN132', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (136, 2, 'OPDN133', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (137, 4, 'OPDN134', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (138, 4, 'OPDN135', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (139, 2, 'OPDN136', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (140, 1, 'OPDN137', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (141, 7, 'OPDN138', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (142, 1, 'OPDN139', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (143, 7, 'OPDN140', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (144, 8, 'OPDN141', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (145, 10, 'OPDN142', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (146, 11, 'OPDN143', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (147, 11, 'OPDN144', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (148, 16, 'OPDN145', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (149, 16, 'OPDN146', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (150, 16, 'OPDN147', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (151, 17, 'OPDN148', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (152, 18, 'OPDN149', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (153, 18, 'OPDN150', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (154, 20, 'OPDN151', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (155, 21, 'OPDN152', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (156, 19, 'OPDN153', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (157, 17, 'OPDN154', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (158, 17, 'OPDN155', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (159, 1, 'OPDN156', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (160, 30, 'OPDN157', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (161, 30, 'OPDN158', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (162, 31, 'OPDN159', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (163, 17, 'OPDN160', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (164, 32, 'OPDN161', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (165, 36, 'OPDN162', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (166, 37, 'OPDN163', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (167, 36, 'OPDN164', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (168, 1, 'OPDN165', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (169, 2, 'OPDN166', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (170, 4, 'OPDN167', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (171, 4, 'OPDN168', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (172, 2, 'OPDN169', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (173, 1, 'OPDN170', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (174, 7, 'OPDN171', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (175, 1, 'OPDN172', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (176, 7, 'OPDN173', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (177, 8, 'OPDN174', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (178, 10, 'OPDN175', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (179, 11, 'OPDN176', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (180, 11, 'OPDN177', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (181, 16, 'OPDN178', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (182, 16, 'OPDN179', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (183, 16, 'OPDN180', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (184, 17, 'OPDN181', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (185, 18, 'OPDN182', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (186, 18, 'OPDN183', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (187, 20, 'OPDN184', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (188, 21, 'OPDN185', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (189, 19, 'OPDN186', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (190, 17, 'OPDN187', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (191, 17, 'OPDN188', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (192, 1, 'OPDN189', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (193, 30, 'OPDN190', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (194, 30, 'OPDN191', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (195, 31, 'OPDN192', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (196, 17, 'OPDN193', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (197, 32, 'OPDN194', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (198, 36, 'OPDN195', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (199, 37, 'OPDN196', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (200, 36, 'OPDN197', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (201, 1, 'OPDN198', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (202, 2, 'OPDN199', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (203, 4, 'OPDN200', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (204, 4, 'OPDN201', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (205, 2, 'OPDN202', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (206, 1, 'OPDN203', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (207, 7, 'OPDN204', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (208, 1, 'OPDN205', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (209, 7, 'OPDN206', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (210, 8, 'OPDN207', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (211, 10, 'OPDN208', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (212, 11, 'OPDN209', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (213, 11, 'OPDN210', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (214, 16, 'OPDN211', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (215, 16, 'OPDN212', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (216, 16, 'OPDN213', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (217, 17, 'OPDN214', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (218, 18, 'OPDN215', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (219, 18, 'OPDN216', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (220, 20, 'OPDN217', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (221, 21, 'OPDN218', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (222, 19, 'OPDN219', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (223, 17, 'OPDN220', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (224, 17, 'OPDN221', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (225, 1, 'OPDN222', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (226, 30, 'OPDN223', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (227, 30, 'OPDN224', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (228, 31, 'OPDN225', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (229, 17, 'OPDN226', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (230, 32, 'OPDN227', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (231, 36, 'OPDN228', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (232, 37, 'OPDN229', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (233, 36, 'OPDN230', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (234, 1, 'OPDN231', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (235, 2, 'OPDN232', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (236, 4, 'OPDN233', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (237, 4, 'OPDN234', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (238, 2, 'OPDN235', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (239, 1, 'OPDN236', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (240, 7, 'OPDN237', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (241, 1, 'OPDN238', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (242, 7, 'OPDN239', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (243, 8, 'OPDN240', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (244, 10, 'OPDN241', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (245, 11, 'OPDN242', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (246, 11, 'OPDN243', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (247, 16, 'OPDN244', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (248, 16, 'OPDN245', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (249, 16, 'OPDN246', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (250, 17, 'OPDN247', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (251, 18, 'OPDN248', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (252, 18, 'OPDN249', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (253, 20, 'OPDN250', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (254, 21, 'OPDN251', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (255, 19, 'OPDN252', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (256, 17, 'OPDN253', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (257, 17, 'OPDN254', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (258, 1, 'OPDN255', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (259, 30, 'OPDN256', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (260, 30, 'OPDN257', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (261, 31, 'OPDN258', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (262, 17, 'OPDN259', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (263, 32, 'OPDN260', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (264, 36, 'OPDN261', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (265, 37, 'OPDN262', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (266, 36, 'OPDN263', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (267, 1, 'OPDN264', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (268, 2, 'OPDN265', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (269, 4, 'OPDN266', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (270, 4, 'OPDN267', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (271, 2, 'OPDN268', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (272, 1, 'OPDN269', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (273, 7, 'OPDN270', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (274, 1, 'OPDN271', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (275, 7, 'OPDN272', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (276, 8, 'OPDN273', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (277, 10, 'OPDN274', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (278, 11, 'OPDN275', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (279, 11, 'OPDN276', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (280, 16, 'OPDN277', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (281, 16, 'OPDN278', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (282, 16, 'OPDN279', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (283, 17, 'OPDN280', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (284, 18, 'OPDN281', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (285, 18, 'OPDN282', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (286, 20, 'OPDN283', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (287, 21, 'OPDN284', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (288, 19, 'OPDN285', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (289, 17, 'OPDN286', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (290, 17, 'OPDN287', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (291, 1, 'OPDN288', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (292, 30, 'OPDN289', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (293, 30, 'OPDN290', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (294, 31, 'OPDN291', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (295, 17, 'OPDN292', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (296, 32, 'OPDN293', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (297, 36, 'OPDN294', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (298, 37, 'OPDN295', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (299, 36, 'OPDN296', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (300, 1, 'OPDN297', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (301, 2, 'OPDN298', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (302, 4, 'OPDN299', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (303, 4, 'OPDN300', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (304, 2, 'OPDN301', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (305, 1, 'OPDN302', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (306, 7, 'OPDN303', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (307, 1, 'OPDN304', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (308, 7, 'OPDN305', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (309, 8, 'OPDN306', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (310, 10, 'OPDN307', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (311, 11, 'OPDN308', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (312, 11, 'OPDN309', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (313, 16, 'OPDN310', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (314, 16, 'OPDN311', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (315, 16, 'OPDN312', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (316, 17, 'OPDN313', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (317, 18, 'OPDN314', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (318, 18, 'OPDN315', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (319, 20, 'OPDN316', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (320, 21, 'OPDN317', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (321, 19, 'OPDN318', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (322, 17, 'OPDN319', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (323, 17, 'OPDN320', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (324, 1, 'OPDN321', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (325, 30, 'OPDN322', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (326, 30, 'OPDN323', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (327, 31, 'OPDN324', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (328, 17, 'OPDN325', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (329, 32, 'OPDN326', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (330, 36, 'OPDN327', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (331, 37, 'OPDN328', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (332, 36, 'OPDN329', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (333, 1, 'OPDN330', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (334, 2, 'OPDN331', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (335, 4, 'OPDN332', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (336, 4, 'OPDN333', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (337, 2, 'OPDN334', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (338, 1, 'OPDN335', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (339, 7, 'OPDN336', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (340, 1, 'OPDN337', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (341, 7, 'OPDN338', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (342, 8, 'OPDN339', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (343, 10, 'OPDN340', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (344, 11, 'OPDN341', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (345, 11, 'OPDN342', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (346, 16, 'OPDN343', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (347, 16, 'OPDN344', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (348, 16, 'OPDN345', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (349, 17, 'OPDN346', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (350, 18, 'OPDN347', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (351, 18, 'OPDN348', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (352, 20, 'OPDN349', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (353, 21, 'OPDN350', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (354, 19, 'OPDN351', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (355, 17, 'OPDN352', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (356, 17, 'OPDN353', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (357, 1, 'OPDN354', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (358, 30, 'OPDN355', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (359, 30, 'OPDN356', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (360, 31, 'OPDN357', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (361, 17, 'OPDN358', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (362, 32, 'OPDN359', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (363, 36, 'OPDN360', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (364, 37, 'OPDN361', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (365, 36, 'OPDN362', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (366, 1, 'OPDN363', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (367, 2, 'OPDN364', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (368, 4, 'OPDN365', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (369, 4, 'OPDN366', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (370, 2, 'OPDN367', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (371, 1, 'OPDN368', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (372, 7, 'OPDN369', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (373, 1, 'OPDN370', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (374, 7, 'OPDN371', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (375, 8, 'OPDN372', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (376, 10, 'OPDN373', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (377, 11, 'OPDN374', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (378, 11, 'OPDN375', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (379, 16, 'OPDN376', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (380, 16, 'OPDN377', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (381, 16, 'OPDN378', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (382, 17, 'OPDN379', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (383, 18, 'OPDN380', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (384, 18, 'OPDN381', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (385, 20, 'OPDN382', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (386, 21, 'OPDN383', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (387, 19, 'OPDN384', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (388, 17, 'OPDN385', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (389, 17, 'OPDN386', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (390, 1, 'OPDN387', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (391, 30, 'OPDN388', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (392, 30, 'OPDN389', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (393, 31, 'OPDN390', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (394, 17, 'OPDN391', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (395, 32, 'OPDN392', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (396, 36, 'OPDN393', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (397, 37, 'OPDN394', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (398, 36, 'OPDN395', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (399, 1, 'OPDN396', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (400, 2, 'OPDN397', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (401, 4, 'OPDN398', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (402, 4, 'OPDN399', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (403, 2, 'OPDN400', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (404, 1, 'OPDN401', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (405, 7, 'OPDN402', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (406, 1, 'OPDN403', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (407, 7, 'OPDN404', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (408, 8, 'OPDN405', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (409, 10, 'OPDN406', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (410, 11, 'OPDN407', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (411, 11, 'OPDN408', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (412, 16, 'OPDN409', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (413, 16, 'OPDN410', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (414, 16, 'OPDN411', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (415, 17, 'OPDN412', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (416, 18, 'OPDN413', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (417, 18, 'OPDN414', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (418, 20, 'OPDN415', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (419, 21, 'OPDN416', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (420, 19, 'OPDN417', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (421, 17, 'OPDN418', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (422, 17, 'OPDN419', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (423, 1, 'OPDN420', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (424, 30, 'OPDN421', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (425, 30, 'OPDN422', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (426, 31, 'OPDN423', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (427, 17, 'OPDN424', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (428, 32, 'OPDN425', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (429, 36, 'OPDN426', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (430, 37, 'OPDN427', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (431, 36, 'OPDN428', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (432, 1, 'OPDN429', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (433, 2, 'OPDN430', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (434, 4, 'OPDN431', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (435, 4, 'OPDN432', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (436, 2, 'OPDN433', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (437, 1, 'OPDN434', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (438, 7, 'OPDN435', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (439, 1, 'OPDN436', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (440, 7, 'OPDN437', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (441, 8, 'OPDN438', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (442, 10, 'OPDN439', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (443, 11, 'OPDN440', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (444, 11, 'OPDN441', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (445, 16, 'OPDN442', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (446, 16, 'OPDN443', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (447, 16, 'OPDN444', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (448, 17, 'OPDN445', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (449, 18, 'OPDN446', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (450, 18, 'OPDN447', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (451, 20, 'OPDN448', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (452, 21, 'OPDN449', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (453, 19, 'OPDN450', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (454, 17, 'OPDN451', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (455, 17, 'OPDN452', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (456, 1, 'OPDN453', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (457, 30, 'OPDN454', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (458, 30, 'OPDN455', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (459, 31, 'OPDN456', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (460, 17, 'OPDN457', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (461, 32, 'OPDN458', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (462, 36, 'OPDN459', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (463, 37, 'OPDN460', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (464, 36, 'OPDN461', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (465, 1, 'OPDN462', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (466, 2, 'OPDN463', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (467, 4, 'OPDN464', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (468, 4, 'OPDN465', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (469, 2, 'OPDN466', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (470, 1, 'OPDN467', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (471, 7, 'OPDN468', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (472, 1, 'OPDN469', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (473, 7, 'OPDN470', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (474, 8, 'OPDN471', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (475, 10, 'OPDN472', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (476, 11, 'OPDN473', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (477, 11, 'OPDN474', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (478, 16, 'OPDN475', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (479, 16, 'OPDN476', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (480, 16, 'OPDN477', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (481, 17, 'OPDN478', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (482, 18, 'OPDN479', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (483, 18, 'OPDN480', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (484, 20, 'OPDN481', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (485, 21, 'OPDN482', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (486, 19, 'OPDN483', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (487, 17, 'OPDN484', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (488, 17, 'OPDN485', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (489, 1, 'OPDN486', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (490, 30, 'OPDN487', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (491, 30, 'OPDN488', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (492, 31, 'OPDN489', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (493, 17, 'OPDN490', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (494, 32, 'OPDN491', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (495, 36, 'OPDN492', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (496, 37, 'OPDN493', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (497, 36, 'OPDN494', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (498, 1, 'OPDN495', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (499, 2, 'OPDN496', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (500, 4, 'OPDN497', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (501, 4, 'OPDN498', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (502, 2, 'OPDN499', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (503, 1, 'OPDN500', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (504, 7, 'OPDN501', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (505, 1, 'OPDN502', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (506, 7, 'OPDN503', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (507, 8, 'OPDN504', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (508, 10, 'OPDN505', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (509, 11, 'OPDN506', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (510, 11, 'OPDN507', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (511, 16, 'OPDN508', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (512, 16, 'OPDN509', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (513, 16, 'OPDN510', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (514, 17, 'OPDN511', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (515, 18, 'OPDN512', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (516, 18, 'OPDN513', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (517, 20, 'OPDN514', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (518, 21, 'OPDN515', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (519, 19, 'OPDN516', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (520, 17, 'OPDN517', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (521, 17, 'OPDN518', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (522, 1, 'OPDN519', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (523, 30, 'OPDN520', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (524, 30, 'OPDN521', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (525, 31, 'OPDN522', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (526, 17, 'OPDN523', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (527, 32, 'OPDN524', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (528, 36, 'OPDN525', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (529, 37, 'OPDN526', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (530, 36, 'OPDN527', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (531, 1, 'OPDN528', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (532, 2, 'OPDN529', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (533, 4, 'OPDN530', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (534, 4, 'OPDN531', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (535, 2, 'OPDN532', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (536, 1, 'OPDN533', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (537, 7, 'OPDN534', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (538, 1, 'OPDN535', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (539, 7, 'OPDN536', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (540, 8, 'OPDN537', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (541, 10, 'OPDN538', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (542, 11, 'OPDN539', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (543, 11, 'OPDN540', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (544, 16, 'OPDN541', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (545, 16, 'OPDN542', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (546, 16, 'OPDN543', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (547, 17, 'OPDN544', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (548, 18, 'OPDN545', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (549, 18, 'OPDN546', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (550, 20, 'OPDN547', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (551, 21, 'OPDN548', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (552, 19, 'OPDN549', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (553, 17, 'OPDN550', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (554, 17, 'OPDN551', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (555, 1, 'OPDN552', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (556, 30, 'OPDN553', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (557, 30, 'OPDN554', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (558, 31, 'OPDN555', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (559, 17, 'OPDN556', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (560, 32, 'OPDN557', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (561, 36, 'OPDN558', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (562, 37, 'OPDN559', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (563, 36, 'OPDN560', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (564, 1, 'OPDN561', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (565, 2, 'OPDN562', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (566, 4, 'OPDN563', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (567, 4, 'OPDN564', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (568, 2, 'OPDN565', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (569, 1, 'OPDN566', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (570, 7, 'OPDN567', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (571, 1, 'OPDN568', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (572, 7, 'OPDN569', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (573, 8, 'OPDN570', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (574, 10, 'OPDN571', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (575, 11, 'OPDN572', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (576, 11, 'OPDN573', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (577, 16, 'OPDN574', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (578, 16, 'OPDN575', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (579, 16, 'OPDN576', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (580, 17, 'OPDN577', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (581, 18, 'OPDN578', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (582, 18, 'OPDN579', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (583, 20, 'OPDN580', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (584, 21, 'OPDN581', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (585, 19, 'OPDN582', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (586, 17, 'OPDN583', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (587, 17, 'OPDN584', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (588, 1, 'OPDN585', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (589, 30, 'OPDN586', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (590, 30, 'OPDN587', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (591, 31, 'OPDN588', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (592, 17, 'OPDN589', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (593, 32, 'OPDN590', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (594, 36, 'OPDN591', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (595, 37, 'OPDN592', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (596, 36, 'OPDN593', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (597, 1, 'OPDN594', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (598, 2, 'OPDN595', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (599, 4, 'OPDN596', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (600, 4, 'OPDN597', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (601, 2, 'OPDN598', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (602, 1, 'OPDN599', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (603, 7, 'OPDN600', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (604, 1, 'OPDN601', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (605, 7, 'OPDN602', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (606, 8, 'OPDN603', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (607, 10, 'OPDN604', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (608, 11, 'OPDN605', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (609, 11, 'OPDN606', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (610, 16, 'OPDN607', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (611, 16, 'OPDN608', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (612, 16, 'OPDN609', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (613, 17, 'OPDN610', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (614, 18, 'OPDN611', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (615, 18, 'OPDN612', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (616, 20, 'OPDN613', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (617, 21, 'OPDN614', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (618, 19, 'OPDN615', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (619, 17, 'OPDN616', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (620, 17, 'OPDN617', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (621, 1, 'OPDN618', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (622, 30, 'OPDN619', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (623, 30, 'OPDN620', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (624, 31, 'OPDN621', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (625, 17, 'OPDN622', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (626, 32, 'OPDN623', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (627, 36, 'OPDN624', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (628, 37, 'OPDN625', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (629, 36, 'OPDN626', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (630, 1, 'OPDN627', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (631, 2, 'OPDN628', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (632, 4, 'OPDN629', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (633, 4, 'OPDN630', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (634, 2, 'OPDN631', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (635, 1, 'OPDN632', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (636, 7, 'OPDN633', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (637, 1, 'OPDN634', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (638, 7, 'OPDN635', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (639, 8, 'OPDN636', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (640, 10, 'OPDN637', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (641, 11, 'OPDN638', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (642, 11, 'OPDN639', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (643, 16, 'OPDN640', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (644, 16, 'OPDN641', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (645, 16, 'OPDN642', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (646, 17, 'OPDN643', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (647, 18, 'OPDN644', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (648, 18, 'OPDN645', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (649, 20, 'OPDN646', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (650, 21, 'OPDN647', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (651, 19, 'OPDN648', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (652, 17, 'OPDN649', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (653, 17, 'OPDN650', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (654, 1, 'OPDN651', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (655, 30, 'OPDN652', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (656, 30, 'OPDN653', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (657, 31, 'OPDN654', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (658, 17, 'OPDN655', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (659, 32, 'OPDN656', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (660, 36, 'OPDN657', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (661, 37, 'OPDN658', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (662, 36, 'OPDN659', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (663, 1, 'OPDN660', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (664, 2, 'OPDN661', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (665, 4, 'OPDN662', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (666, 4, 'OPDN663', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (667, 2, 'OPDN664', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (668, 1, 'OPDN665', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (669, 7, 'OPDN666', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (670, 1, 'OPDN667', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (671, 7, 'OPDN668', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (672, 8, 'OPDN669', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (673, 10, 'OPDN670', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (674, 11, 'OPDN671', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (675, 11, 'OPDN672', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (676, 16, 'OPDN673', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (677, 16, 'OPDN674', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (678, 16, 'OPDN675', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (679, 17, 'OPDN676', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (680, 18, 'OPDN677', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (681, 18, 'OPDN678', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (682, 20, 'OPDN679', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (683, 21, 'OPDN680', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (684, 19, 'OPDN681', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (685, 17, 'OPDN682', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (686, 17, 'OPDN683', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (687, 1, 'OPDN684', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (688, 30, 'OPDN685', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (689, 30, 'OPDN686', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (690, 31, 'OPDN687', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (691, 17, 'OPDN688', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (692, 32, 'OPDN689', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (693, 36, 'OPDN690', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (694, 37, 'OPDN691', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (695, 36, 'OPDN692', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (696, 1, 'OPDN693', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (697, 2, 'OPDN694', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (698, 4, 'OPDN695', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (699, 4, 'OPDN696', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (700, 2, 'OPDN697', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (701, 1, 'OPDN698', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (702, 7, 'OPDN699', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (703, 1, 'OPDN700', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (704, 7, 'OPDN701', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (705, 8, 'OPDN702', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (706, 10, 'OPDN703', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (707, 11, 'OPDN704', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (708, 11, 'OPDN705', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (709, 16, 'OPDN706', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (710, 16, 'OPDN707', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (711, 16, 'OPDN708', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (712, 17, 'OPDN709', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (713, 18, 'OPDN710', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (714, 18, 'OPDN711', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (715, 20, 'OPDN712', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (716, 21, 'OPDN713', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (717, 19, 'OPDN714', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (718, 17, 'OPDN715', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (719, 17, 'OPDN716', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (720, 1, 'OPDN717', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (721, 30, 'OPDN718', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (722, 30, 'OPDN719', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (723, 31, 'OPDN720', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (724, 17, 'OPDN721', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (725, 32, 'OPDN722', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (726, 36, 'OPDN723', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (727, 37, 'OPDN724', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (728, 36, 'OPDN725', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (729, 1, 'OPDN726', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (730, 2, 'OPDN727', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (731, 4, 'OPDN728', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (732, 4, 'OPDN729', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (733, 2, 'OPDN730', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (734, 1, 'OPDN731', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (735, 7, 'OPDN732', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (736, 1, 'OPDN733', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (737, 7, 'OPDN734', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (738, 8, 'OPDN735', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (739, 10, 'OPDN736', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (740, 11, 'OPDN737', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (741, 11, 'OPDN738', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (742, 16, 'OPDN739', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (743, 16, 'OPDN740', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (744, 16, 'OPDN741', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (745, 17, 'OPDN742', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (746, 18, 'OPDN743', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (747, 18, 'OPDN744', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (748, 20, 'OPDN745', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (749, 21, 'OPDN746', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (750, 19, 'OPDN747', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (751, 17, 'OPDN748', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (752, 17, 'OPDN749', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (753, 1, 'OPDN750', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (754, 30, 'OPDN751', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (755, 30, 'OPDN752', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (756, 31, 'OPDN753', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (757, 17, 'OPDN754', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (758, 32, 'OPDN755', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (759, 36, 'OPDN756', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (760, 37, 'OPDN757', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (761, 36, 'OPDN758', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (762, 1, 'OPDN759', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (763, 2, 'OPDN760', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (764, 4, 'OPDN761', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (765, 4, 'OPDN762', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (766, 2, 'OPDN763', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (767, 1, 'OPDN764', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (768, 7, 'OPDN765', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (769, 1, 'OPDN766', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (770, 7, 'OPDN767', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (771, 8, 'OPDN768', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (772, 10, 'OPDN769', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (773, 11, 'OPDN770', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (774, 11, 'OPDN771', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (775, 16, 'OPDN772', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (776, 16, 'OPDN773', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (777, 16, 'OPDN774', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (778, 17, 'OPDN775', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (779, 18, 'OPDN776', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (780, 18, 'OPDN777', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (781, 20, 'OPDN778', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (782, 21, 'OPDN779', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (783, 19, 'OPDN780', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (784, 17, 'OPDN781', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (785, 17, 'OPDN782', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (786, 1, 'OPDN783', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (787, 30, 'OPDN784', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (788, 30, 'OPDN785', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (789, 31, 'OPDN786', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (790, 17, 'OPDN787', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (791, 32, 'OPDN788', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (792, 36, 'OPDN789', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (793, 37, 'OPDN790', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (794, 36, 'OPDN791', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (795, 1, 'OPDN792', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (796, 2, 'OPDN793', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (797, 4, 'OPDN794', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (798, 4, 'OPDN795', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (799, 2, 'OPDN796', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (800, 1, 'OPDN797', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (801, 7, 'OPDN798', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (802, 1, 'OPDN799', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (803, 7, 'OPDN800', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (804, 8, 'OPDN801', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (805, 10, 'OPDN802', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (806, 11, 'OPDN803', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (807, 11, 'OPDN804', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (808, 16, 'OPDN805', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (809, 16, 'OPDN806', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (810, 16, 'OPDN807', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (811, 17, 'OPDN808', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (812, 18, 'OPDN809', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (813, 18, 'OPDN810', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (814, 20, 'OPDN811', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (815, 21, 'OPDN812', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (816, 19, 'OPDN813', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (817, 17, 'OPDN814', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (818, 17, 'OPDN815', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (819, 1, 'OPDN816', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (820, 30, 'OPDN817', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (821, 30, 'OPDN818', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (822, 31, 'OPDN819', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (823, 17, 'OPDN820', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (824, 32, 'OPDN821', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (825, 36, 'OPDN822', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (826, 37, 'OPDN823', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (827, 36, 'OPDN824', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (828, 1, 'OPDN825', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (829, 2, 'OPDN826', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (830, 4, 'OPDN827', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (831, 4, 'OPDN828', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (832, 2, 'OPDN829', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (833, 1, 'OPDN830', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (834, 7, 'OPDN831', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (835, 1, 'OPDN832', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (836, 7, 'OPDN833', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (837, 8, 'OPDN834', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (838, 10, 'OPDN835', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (839, 11, 'OPDN836', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (840, 11, 'OPDN837', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (841, 16, 'OPDN838', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (842, 16, 'OPDN839', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (843, 16, 'OPDN840', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (844, 17, 'OPDN841', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (845, 18, 'OPDN842', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (846, 18, 'OPDN843', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (847, 20, 'OPDN844', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (848, 21, 'OPDN845', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (849, 19, 'OPDN846', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (850, 17, 'OPDN847', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (851, 17, 'OPDN848', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (852, 1, 'OPDN849', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (853, 30, 'OPDN850', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (854, 30, 'OPDN851', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (855, 31, 'OPDN852', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (856, 17, 'OPDN853', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (857, 32, 'OPDN854', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (858, 36, 'OPDN855', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (859, 37, 'OPDN856', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (860, 36, 'OPDN857', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (861, 1, 'OPDN858', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (862, 2, 'OPDN859', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (863, 4, 'OPDN860', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (864, 4, 'OPDN861', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (865, 2, 'OPDN862', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (866, 1, 'OPDN863', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (867, 7, 'OPDN864', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (868, 1, 'OPDN865', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (869, 7, 'OPDN866', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (870, 8, 'OPDN867', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (871, 10, 'OPDN868', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (872, 11, 'OPDN869', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (873, 11, 'OPDN870', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (874, 16, 'OPDN871', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (875, 16, 'OPDN872', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (876, 16, 'OPDN873', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (877, 17, 'OPDN874', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (878, 18, 'OPDN875', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (879, 18, 'OPDN876', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (880, 20, 'OPDN877', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (881, 21, 'OPDN878', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (882, 19, 'OPDN879', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (883, 17, 'OPDN880', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (884, 17, 'OPDN881', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (885, 1, 'OPDN882', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (886, 30, 'OPDN883', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (887, 30, 'OPDN884', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (888, 31, 'OPDN885', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (889, 17, 'OPDN886', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (890, 32, 'OPDN887', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (891, 36, 'OPDN888', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (892, 37, 'OPDN889', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (893, 36, 'OPDN890', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (894, 1, 'OPDN891', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (895, 2, 'OPDN892', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (896, 4, 'OPDN893', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (897, 4, 'OPDN894', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (898, 2, 'OPDN895', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (899, 1, 'OPDN896', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (900, 7, 'OPDN897', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (901, 1, 'OPDN898', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (902, 7, 'OPDN899', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (903, 8, 'OPDN900', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (904, 10, 'OPDN901', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (905, 11, 'OPDN902', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (906, 11, 'OPDN903', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (907, 16, 'OPDN904', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (908, 16, 'OPDN905', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (909, 16, 'OPDN906', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (910, 17, 'OPDN907', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (911, 18, 'OPDN908', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (912, 18, 'OPDN909', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (913, 20, 'OPDN910', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (914, 21, 'OPDN911', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (915, 19, 'OPDN912', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (916, 17, 'OPDN913', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (917, 17, 'OPDN914', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (918, 1, 'OPDN915', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (919, 30, 'OPDN916', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (920, 30, 'OPDN917', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (921, 31, 'OPDN918', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (922, 17, 'OPDN919', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (923, 32, 'OPDN920', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (924, 36, 'OPDN921', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (925, 37, 'OPDN922', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (926, 36, 'OPDN923', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (927, 1, 'OPDN924', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (928, 2, 'OPDN925', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (929, 4, 'OPDN926', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (930, 4, 'OPDN927', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (931, 2, 'OPDN928', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (932, 1, 'OPDN929', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (933, 7, 'OPDN930', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (934, 1, 'OPDN931', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (935, 7, 'OPDN932', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (936, 8, 'OPDN933', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (937, 10, 'OPDN934', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (938, 11, 'OPDN935', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (939, 11, 'OPDN936', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (940, 16, 'OPDN937', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (941, 16, 'OPDN938', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (942, 16, 'OPDN939', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (943, 17, 'OPDN940', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (944, 18, 'OPDN941', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (945, 18, 'OPDN942', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (946, 20, 'OPDN943', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (947, 21, 'OPDN944', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (948, 19, 'OPDN945', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (949, 17, 'OPDN946', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (950, 17, 'OPDN947', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (951, 1, 'OPDN948', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (952, 30, 'OPDN949', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (953, 30, 'OPDN950', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (954, 31, 'OPDN951', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (955, 17, 'OPDN952', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (956, 32, 'OPDN953', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (957, 36, 'OPDN954', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (958, 37, 'OPDN955', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (959, 36, 'OPDN956', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (960, 1, 'OPDN957', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (961, 2, 'OPDN958', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (962, 4, 'OPDN959', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (963, 4, 'OPDN960', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (964, 2, 'OPDN961', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (965, 1, 'OPDN962', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (966, 7, 'OPDN963', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (967, 1, 'OPDN964', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (968, 7, 'OPDN965', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (969, 8, 'OPDN966', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (970, 10, 'OPDN967', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (971, 11, 'OPDN968', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (972, 11, 'OPDN969', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (973, 16, 'OPDN970', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (974, 16, 'OPDN971', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (975, 16, 'OPDN972', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (976, 17, 'OPDN973', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (977, 18, 'OPDN974', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (978, 18, 'OPDN975', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (979, 20, 'OPDN976', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (980, 21, 'OPDN977', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (981, 19, 'OPDN978', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (982, 17, 'OPDN979', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (983, 17, 'OPDN980', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (984, 1, 'OPDN981', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (985, 30, 'OPDN982', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (986, 30, 'OPDN983', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (987, 31, 'OPDN984', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (988, 17, 'OPDN985', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (989, 32, 'OPDN986', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (990, 36, 'OPDN987', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (991, 37, 'OPDN988', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (992, 36, 'OPDN989', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (993, 1, 'OPDN990', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (994, 2, 'OPDN991', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (995, 4, 'OPDN992', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (996, 4, 'OPDN993', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (997, 2, 'OPDN994', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (998, 1, 'OPDN995', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (999, 7, 'OPDN996', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1000, 1, 'OPDN997', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1001, 7, 'OPDN998', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1002, 8, 'OPDN999', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1003, 10, 'OPDN1000', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1004, 11, 'OPDN1001', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1005, 11, 'OPDN1002', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1006, 16, 'OPDN1003', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1007, 16, 'OPDN1004', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1008, 16, 'OPDN1005', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1009, 17, 'OPDN1006', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1010, 18, 'OPDN1007', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1011, 18, 'OPDN1008', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1012, 20, 'OPDN1009', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1013, 21, 'OPDN1010', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1014, 19, 'OPDN1011', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1015, 17, 'OPDN1012', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1016, 17, 'OPDN1013', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1017, 1, 'OPDN1014', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1018, 30, 'OPDN1015', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1019, 30, 'OPDN1016', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1020, 31, 'OPDN1017', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1021, 17, 'OPDN1018', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1022, 32, 'OPDN1019', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1023, 36, 'OPDN1020', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1024, 37, 'OPDN1021', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1025, 36, 'OPDN1022', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1026, 1, 'OPDN1023', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1027, 2, 'OPDN1024', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1028, 4, 'OPDN1025', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1029, 4, 'OPDN1026', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1030, 2, 'OPDN1027', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1031, 1, 'OPDN1028', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1032, 7, 'OPDN1029', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1033, 1, 'OPDN1030', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1034, 7, 'OPDN1031', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1035, 8, 'OPDN1032', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1036, 10, 'OPDN1033', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1037, 11, 'OPDN1034', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1038, 11, 'OPDN1035', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1039, 16, 'OPDN1036', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1040, 16, 'OPDN1037', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1041, 16, 'OPDN1038', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1042, 17, 'OPDN1039', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1043, 18, 'OPDN1040', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1044, 18, 'OPDN1041', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1045, 20, 'OPDN1042', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1046, 21, 'OPDN1043', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1047, 19, 'OPDN1044', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1048, 17, 'OPDN1045', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1049, 17, 'OPDN1046', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1050, 1, 'OPDN1047', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1051, 30, 'OPDN1048', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1052, 30, 'OPDN1049', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1053, 31, 'OPDN1050', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1054, 17, 'OPDN1051', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1055, 32, 'OPDN1052', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1056, 36, 'OPDN1053', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1057, 37, 'OPDN1054', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1058, 36, 'OPDN1055', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1059, 1, 'OPDN1056', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1060, 2, 'OPDN1057', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1061, 4, 'OPDN1058', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1062, 4, 'OPDN1059', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1063, 2, 'OPDN1060', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1064, 1, 'OPDN1061', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1065, 7, 'OPDN1062', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1066, 1, 'OPDN1063', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1067, 7, 'OPDN1064', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1068, 8, 'OPDN1065', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1069, 10, 'OPDN1066', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1070, 11, 'OPDN1067', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1071, 11, 'OPDN1068', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1072, 16, 'OPDN1069', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1073, 16, 'OPDN1070', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1074, 16, 'OPDN1071', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1075, 17, 'OPDN1072', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1076, 18, 'OPDN1073', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1077, 18, 'OPDN1074', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1078, 20, 'OPDN1075', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1079, 21, 'OPDN1076', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1080, 19, 'OPDN1077', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1081, 17, 'OPDN1078', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1082, 17, 'OPDN1079', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1083, 1, 'OPDN1080', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1084, 30, 'OPDN1081', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1085, 30, 'OPDN1082', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1086, 31, 'OPDN1083', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1087, 17, 'OPDN1084', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1088, 32, 'OPDN1085', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1089, 36, 'OPDN1086', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1090, 37, 'OPDN1087', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1091, 36, 'OPDN1088', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1092, 1, 'OPDN1089', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1093, 2, 'OPDN1090', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1094, 4, 'OPDN1091', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1095, 4, 'OPDN1092', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1096, 2, 'OPDN1093', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1097, 1, 'OPDN1094', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1098, 7, 'OPDN1095', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1099, 1, 'OPDN1096', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1100, 7, 'OPDN1097', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1101, 8, 'OPDN1098', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1102, 10, 'OPDN1099', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1103, 11, 'OPDN1100', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1104, 11, 'OPDN1101', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1105, 16, 'OPDN1102', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1106, 16, 'OPDN1103', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1107, 16, 'OPDN1104', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1108, 17, 'OPDN1105', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1109, 18, 'OPDN1106', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1110, 18, 'OPDN1107', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1111, 20, 'OPDN1108', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1112, 21, 'OPDN1109', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1113, 19, 'OPDN1110', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1114, 17, 'OPDN1111', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1115, 17, 'OPDN1112', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1116, 1, 'OPDN1113', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1117, 30, 'OPDN1114', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1118, 30, 'OPDN1115', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1119, 31, 'OPDN1116', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1120, 17, 'OPDN1117', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1121, 32, 'OPDN1118', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1122, 36, 'OPDN1119', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1123, 37, 'OPDN1120', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1124, 36, 'OPDN1121', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1125, 1, 'OPDN1122', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1126, 2, 'OPDN1123', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1127, 4, 'OPDN1124', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1128, 4, 'OPDN1125', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1129, 2, 'OPDN1126', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1130, 1, 'OPDN1127', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1131, 7, 'OPDN1128', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1132, 1, 'OPDN1129', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1133, 7, 'OPDN1130', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1134, 8, 'OPDN1131', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1135, 10, 'OPDN1132', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1136, 11, 'OPDN1133', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1137, 11, 'OPDN1134', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1138, 16, 'OPDN1135', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1139, 16, 'OPDN1136', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1140, 16, 'OPDN1137', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1141, 17, 'OPDN1138', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1142, 18, 'OPDN1139', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1143, 18, 'OPDN1140', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1144, 20, 'OPDN1141', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1145, 21, 'OPDN1142', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1146, 19, 'OPDN1143', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1147, 17, 'OPDN1144', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1148, 17, 'OPDN1145', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1149, 1, 'OPDN1146', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1150, 30, 'OPDN1147', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1151, 30, 'OPDN1148', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1152, 31, 'OPDN1149', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1153, 17, 'OPDN1150', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1154, 32, 'OPDN1151', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1155, 36, 'OPDN1152', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1156, 37, 'OPDN1153', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1157, 36, 'OPDN1154', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1158, 1, 'OPDN1155', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1159, 2, 'OPDN1156', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1160, 4, 'OPDN1157', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1161, 4, 'OPDN1158', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1162, 2, 'OPDN1159', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1163, 1, 'OPDN1160', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1164, 7, 'OPDN1161', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1165, 1, 'OPDN1162', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1166, 7, 'OPDN1163', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1167, 8, 'OPDN1164', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1168, 10, 'OPDN1165', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1169, 11, 'OPDN1166', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1170, 11, 'OPDN1167', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1171, 16, 'OPDN1168', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1172, 16, 'OPDN1169', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1173, 16, 'OPDN1170', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1174, 17, 'OPDN1171', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1175, 18, 'OPDN1172', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1176, 18, 'OPDN1173', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1177, 20, 'OPDN1174', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1178, 21, 'OPDN1175', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1179, 19, 'OPDN1176', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1180, 17, 'OPDN1177', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1181, 17, 'OPDN1178', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1182, 1, 'OPDN1179', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1183, 30, 'OPDN1180', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1184, 30, 'OPDN1181', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1185, 31, 'OPDN1182', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1186, 17, 'OPDN1183', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1187, 32, 'OPDN1184', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1188, 36, 'OPDN1185', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1189, 37, 'OPDN1186', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1190, 36, 'OPDN1187', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1191, 1, 'OPDN1188', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1192, 2, 'OPDN1189', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1193, 4, 'OPDN1190', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1194, 4, 'OPDN1191', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1195, 2, 'OPDN1192', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1196, 1, 'OPDN1193', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1197, 7, 'OPDN1194', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1198, 1, 'OPDN1195', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1199, 7, 'OPDN1196', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1200, 8, 'OPDN1197', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1201, 10, 'OPDN1198', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1202, 11, 'OPDN1199', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1203, 11, 'OPDN1200', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1204, 16, 'OPDN1201', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1205, 16, 'OPDN1202', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1206, 16, 'OPDN1203', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1207, 17, 'OPDN1204', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1208, 18, 'OPDN1205', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1209, 18, 'OPDN1206', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1210, 20, 'OPDN1207', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1211, 21, 'OPDN1208', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1212, 19, 'OPDN1209', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1213, 17, 'OPDN1210', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1214, 17, 'OPDN1211', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1215, 1, 'OPDN1212', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1216, 30, 'OPDN1213', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1217, 30, 'OPDN1214', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1218, 31, 'OPDN1215', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1219, 17, 'OPDN1216', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1220, 32, 'OPDN1217', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1221, 36, 'OPDN1218', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1222, 37, 'OPDN1219', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1223, 36, 'OPDN1220', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1224, 1, 'OPDN1221', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1225, 2, 'OPDN1222', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1226, 4, 'OPDN1223', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1227, 4, 'OPDN1224', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1228, 2, 'OPDN1225', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1229, 1, 'OPDN1226', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1230, 7, 'OPDN1227', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1231, 1, 'OPDN1228', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1232, 7, 'OPDN1229', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1233, 8, 'OPDN1230', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1234, 10, 'OPDN1231', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1235, 11, 'OPDN1232', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1236, 11, 'OPDN1233', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1237, 16, 'OPDN1234', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1238, 16, 'OPDN1235', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1239, 16, 'OPDN1236', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1240, 17, 'OPDN1237', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1241, 18, 'OPDN1238', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1242, 18, 'OPDN1239', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1243, 20, 'OPDN1240', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1244, 21, 'OPDN1241', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1245, 19, 'OPDN1242', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1246, 17, 'OPDN1243', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1247, 17, 'OPDN1244', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1248, 1, 'OPDN1245', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1249, 30, 'OPDN1246', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1250, 30, 'OPDN1247', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1251, 31, 'OPDN1248', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1252, 17, 'OPDN1249', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1253, 32, 'OPDN1250', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1254, 36, 'OPDN1251', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1255, 37, 'OPDN1252', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1256, 36, 'OPDN1253', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1257, 1, 'OPDN1254', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1258, 2, 'OPDN1255', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1259, 4, 'OPDN1256', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1260, 4, 'OPDN1257', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1261, 2, 'OPDN1258', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1262, 1, 'OPDN1259', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1263, 7, 'OPDN1260', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1264, 1, 'OPDN1261', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1265, 7, 'OPDN1262', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1266, 8, 'OPDN1263', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1267, 10, 'OPDN1264', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1268, 11, 'OPDN1265', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1269, 11, 'OPDN1266', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1270, 16, 'OPDN1267', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1271, 16, 'OPDN1268', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1272, 16, 'OPDN1269', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1273, 17, 'OPDN1270', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1274, 18, 'OPDN1271', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1275, 18, 'OPDN1272', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1276, 20, 'OPDN1273', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1277, 21, 'OPDN1274', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1278, 19, 'OPDN1275', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1279, 17, 'OPDN1276', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1280, 17, 'OPDN1277', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1281, 1, 'OPDN1278', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1282, 30, 'OPDN1279', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1283, 30, 'OPDN1280', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1284, 31, 'OPDN1281', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1285, 17, 'OPDN1282', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1286, 32, 'OPDN1283', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1287, 36, 'OPDN1284', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1288, 37, 'OPDN1285', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1289, 36, 'OPDN1286', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1290, 1, 'OPDN1287', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1291, 2, 'OPDN1288', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1292, 4, 'OPDN1289', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1293, 4, 'OPDN1290', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1294, 2, 'OPDN1291', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1295, 1, 'OPDN1292', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1296, 7, 'OPDN1293', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1297, 1, 'OPDN1294', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1298, 7, 'OPDN1295', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1299, 8, 'OPDN1296', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1300, 10, 'OPDN1297', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1301, 11, 'OPDN1298', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1302, 11, 'OPDN1299', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1303, 16, 'OPDN1300', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1304, 16, 'OPDN1301', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1305, 16, 'OPDN1302', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1306, 17, 'OPDN1303', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1307, 18, 'OPDN1304', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1308, 18, 'OPDN1305', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1309, 20, 'OPDN1306', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1310, 21, 'OPDN1307', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1311, 19, 'OPDN1308', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1312, 17, 'OPDN1309', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1313, 17, 'OPDN1310', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1314, 1, 'OPDN1311', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1315, 30, 'OPDN1312', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1316, 30, 'OPDN1313', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1317, 31, 'OPDN1314', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1318, 17, 'OPDN1315', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1319, 32, 'OPDN1316', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1320, 36, 'OPDN1317', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1321, 37, 'OPDN1318', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1322, 36, 'OPDN1319', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1323, 1, 'OPDN1320', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1324, 2, 'OPDN1321', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1325, 4, 'OPDN1322', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1326, 4, 'OPDN1323', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1327, 2, 'OPDN1324', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1328, 1, 'OPDN1325', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1329, 7, 'OPDN1326', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1330, 1, 'OPDN1327', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1331, 7, 'OPDN1328', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1332, 8, 'OPDN1329', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1333, 10, 'OPDN1330', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1334, 11, 'OPDN1331', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1335, 11, 'OPDN1332', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1336, 16, 'OPDN1333', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1337, 16, 'OPDN1334', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1338, 16, 'OPDN1335', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1339, 17, 'OPDN1336', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1340, 18, 'OPDN1337', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1341, 18, 'OPDN1338', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1342, 20, 'OPDN1339', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1343, 21, 'OPDN1340', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1344, 19, 'OPDN1341', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1345, 17, 'OPDN1342', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1346, 17, 'OPDN1343', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1347, 1, 'OPDN1344', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1348, 30, 'OPDN1345', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1349, 30, 'OPDN1346', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1350, 31, 'OPDN1347', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1351, 17, 'OPDN1348', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1352, 32, 'OPDN1349', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1353, 36, 'OPDN1350', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1354, 37, 'OPDN1351', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1355, 36, 'OPDN1352', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1356, 1, 'OPDN1353', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1357, 2, 'OPDN1354', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1358, 4, 'OPDN1355', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1359, 4, 'OPDN1356', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1360, 2, 'OPDN1357', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1361, 1, 'OPDN1358', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1362, 7, 'OPDN1359', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1363, 1, 'OPDN1360', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1364, 7, 'OPDN1361', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1365, 8, 'OPDN1362', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1366, 10, 'OPDN1363', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1367, 11, 'OPDN1364', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1368, 11, 'OPDN1365', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1369, 16, 'OPDN1366', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1370, 16, 'OPDN1367', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1371, 16, 'OPDN1368', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1372, 17, 'OPDN1369', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1373, 18, 'OPDN1370', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1374, 18, 'OPDN1371', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1375, 20, 'OPDN1372', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1376, 21, 'OPDN1373', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1377, 19, 'OPDN1374', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1378, 17, 'OPDN1375', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1379, 17, 'OPDN1376', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1380, 1, 'OPDN1377', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1381, 30, 'OPDN1378', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1382, 30, 'OPDN1379', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1383, 31, 'OPDN1380', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1384, 17, 'OPDN1381', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1385, 32, 'OPDN1382', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1386, 36, 'OPDN1383', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1387, 37, 'OPDN1384', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1388, 36, 'OPDN1385', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1389, 1, 'OPDN1386', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1390, 2, 'OPDN1387', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1391, 4, 'OPDN1388', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1392, 4, 'OPDN1389', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1393, 2, 'OPDN1390', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1394, 1, 'OPDN1391', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1395, 7, 'OPDN1392', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1396, 1, 'OPDN1393', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1397, 7, 'OPDN1394', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1398, 8, 'OPDN1395', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1399, 10, 'OPDN1396', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1400, 11, 'OPDN1397', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1401, 11, 'OPDN1398', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1402, 16, 'OPDN1399', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1403, 16, 'OPDN1400', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1404, 16, 'OPDN1401', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1405, 17, 'OPDN1402', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1406, 18, 'OPDN1403', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1407, 18, 'OPDN1404', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1408, 20, 'OPDN1405', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1409, 21, 'OPDN1406', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1410, 19, 'OPDN1407', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1411, 17, 'OPDN1408', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1412, 17, 'OPDN1409', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1413, 1, 'OPDN1410', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1414, 30, 'OPDN1411', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1415, 30, 'OPDN1412', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1416, 31, 'OPDN1413', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1417, 17, 'OPDN1414', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1418, 32, 'OPDN1415', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1419, 36, 'OPDN1416', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1420, 37, 'OPDN1417', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1421, 36, 'OPDN1418', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1422, 1, 'OPDN1419', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1423, 2, 'OPDN1420', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1424, 4, 'OPDN1421', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1425, 4, 'OPDN1422', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1426, 2, 'OPDN1423', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1427, 1, 'OPDN1424', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1428, 7, 'OPDN1425', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1429, 1, 'OPDN1426', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1430, 7, 'OPDN1427', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1431, 8, 'OPDN1428', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1432, 10, 'OPDN1429', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1433, 11, 'OPDN1430', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1434, 11, 'OPDN1431', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1435, 16, 'OPDN1432', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1436, 16, 'OPDN1433', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1437, 16, 'OPDN1434', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1438, 17, 'OPDN1435', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1439, 18, 'OPDN1436', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1440, 18, 'OPDN1437', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1441, 20, 'OPDN1438', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1442, 21, 'OPDN1439', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1443, 19, 'OPDN1440', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1444, 17, 'OPDN1441', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1445, 17, 'OPDN1442', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1446, 1, 'OPDN1443', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1447, 30, 'OPDN1444', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1448, 30, 'OPDN1445', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1449, 31, 'OPDN1446', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1450, 17, 'OPDN1447', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1451, 32, 'OPDN1448', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1452, 36, 'OPDN1449', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1453, 37, 'OPDN1450', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1454, 36, 'OPDN1451', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1455, 1, 'OPDN1452', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1456, 2, 'OPDN1453', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1457, 4, 'OPDN1454', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1458, 4, 'OPDN1455', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1459, 2, 'OPDN1456', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1460, 1, 'OPDN1457', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1461, 7, 'OPDN1458', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1462, 1, 'OPDN1459', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1463, 7, 'OPDN1460', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1464, 8, 'OPDN1461', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1465, 10, 'OPDN1462', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1466, 11, 'OPDN1463', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1467, 11, 'OPDN1464', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1468, 16, 'OPDN1465', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1469, 16, 'OPDN1466', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1470, 16, 'OPDN1467', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1471, 17, 'OPDN1468', '2020-11-30 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1472, 18, 'OPDN1469', '2020-11-30 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1473, 18, 'OPDN1470', '2020-11-30 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1474, 20, 'OPDN1471', '2020-12-02 11:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1475, 21, 'OPDN1472', '2020-12-02 11:46:00', 'fffffffffffff', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1476, 19, 'OPDN1473', '2020-12-02 11:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1477, 17, 'OPDN1474', '2020-12-02 11:51:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1478, 17, 'OPDN1475', '2020-12-01 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1479, 1, 'OPDN1476', '2020-12-05 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1480, 30, 'OPDN1477', '2020-12-07 16:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1481, 30, 'OPDN1478', '2020-12-08 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1482, 31, 'OPDN1479', '2020-12-16 21:50:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', 4, '450.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1483, 17, 'OPDN1480', '2020-12-14 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1484, 32, 'OPDN1481', '2020-12-14 14:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1485, 36, 'OPDN1482', '2020-12-15 14:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1486, 37, 'OPDN1483', '2020-12-18 14:39:00', '', 'No', '', '22', '22', '22', '22', '22', '22', '', 'tttttttttttttttt', '', 2, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1487, 36, 'OPDN1484', '2020-12-18 15:16:00', '', 'No', '', '', '', '', '', '', '', '', 'tttttttt', '', 4, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1488, 1, 'OPDN1485', '2020-11-16 11:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1489, 2, 'OPDN1486', '2020-11-17 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1490, 4, 'OPDN1487', '2020-11-18 10:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1491, 4, 'OPDN1488', '2020-11-24 12:53:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1492, 2, 'OPDN1489', '2020-11-30 12:54:00', '', 'No', '', '', '6', '54', '', '', '', 'dust', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1493, 1, 'OPDN1490', '2020-11-24 12:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1494, 7, 'OPDN1491', '2020-12-01 13:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1495, 1, 'OPDN1492', '2020-12-01 13:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1496, 7, 'OPDN1493', '2020-11-28 15:37:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1497, 8, 'OPDN1494', '2020-11-28 17:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '<p>\r\n\r\nHeader Note\r\n\r\n<br></p>', '<p>\r\n\r\n<div><div>Footer Note</div></div>\r\n\r\n<br></p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1498, 10, 'OPDN1495', '2020-11-28 17:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1499, 11, 'OPDN1496', '2020-11-28 17:34:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1500, 11, 'OPDN1497', '2020-11-28 18:26:00', 'naa', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1501, 16, 'OPDN1498', '2020-11-28 18:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1502, 16, 'OPDN1499', '2020-11-30 15:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cheque', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1503, 16, 'OPDN1500', '2020-11-30 17:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`,